package com.floreantpos.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseDeliveryAddress;
import com.floreantpos.model.dao.CustomerDAO;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "customer" })
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement
public class DeliveryAddress extends BaseDeliveryAddress implements TimedModel {
	private static final long serialVersionUID = 1L;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public DeliveryAddress () {
    }

	/**
	 * Constructor for primary key
	 */
	public DeliveryAddress (java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public String toString() {
		return super.getAddress();
	}

	@XmlTransient
	public Customer getCustomer() {
		if (StringUtils.isNotEmpty(getCustomerId())) {
			return CustomerDAO.getInstance().get(getCustomerId());
		}
		return null;
	}

	public void setCustomer(Customer customer) {
		String customerId = null;
		if (customer != null) {
			customerId = customer.getId();
		}
		super.setCustomerId(customerId);
	}

}