package com.floreantpos.model.dao;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.Customer;
import com.floreantpos.model.Department;
import com.floreantpos.model.Doctor;
import com.floreantpos.swing.PaginationSupport;

public class DoctorDAO extends BaseDoctorDAO {

	public DoctorDAO() {
	}

	public void findByPhoneOrName(String searchString, PaginationSupport tableModel) {
		findByPhoneOrName(searchString, tableModel, null);
	}

	public void findByPhoneOrName(String searchString, PaginationSupport tableModel, Department department) {
		findByAgentPhoneOrName(searchString, null, tableModel, department);
	}

	public void findByAgentPhoneOrName(String searchString, String referrerId, PaginationSupport tableModel, Department department) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(Doctor.class);

			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(Customer.PROP_ACTIVE, true));

			if (StringUtils.isNotEmpty(searchString)) {
				Disjunction disjunction = Restrictions.disjunction();
				disjunction.add(Restrictions.or(Restrictions.ilike(Customer.PROP_NAME, searchString, MatchMode.ANYWHERE),
						Restrictions.ilike(Customer.PROP_MOBILE_NO, searchString, MatchMode.ANYWHERE)));
				criteria.add(disjunction);
			}

			if (StringUtils.isNotBlank(referrerId)) {
				criteria.add(Restrictions.ilike(Customer.PROP_PROPERTIES, "\"doctor.agent.id\":\"%" + referrerId + "%\"", MatchMode.ANYWHERE)); //$NON-NLS-1$ //$NON-NLS-2$
			}
			if (department != null) {
				criteria.add(Restrictions.ilike(Customer.PROP_PROPERTIES, "\"doctor.department.id\":\"%" + department.getId() + "%\"", MatchMode.ANYWHERE)); //$NON-NLS-1$ //$NON-NLS-2$
			}

			tableModel.setNumRows(rowCount(criteria));

			criteria.setFirstResult(tableModel.getCurrentRowIndex());
			criteria.setMaxResults(tableModel.getPageSize());
			criteria.addOrder(Order.asc(Customer.PROP_FIRST_NAME).ignoreCase());
			tableModel.setRows(criteria.list());
		}
	}

	public List<Doctor> findByPhoneOrName(String searchString) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(Doctor.class);

			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(Customer.PROP_ACTIVE, true));

			if (StringUtils.isNotEmpty(searchString)) {
				Disjunction disjunction = Restrictions.disjunction();
				disjunction.add(Restrictions.or(Restrictions.ilike(Customer.PROP_NAME, searchString, MatchMode.ANYWHERE),
						Restrictions.ilike(Customer.PROP_MOBILE_NO, searchString, MatchMode.ANYWHERE),
						Restrictions.ilike(Customer.PROP_MEMBER_ID, searchString, MatchMode.ANYWHERE)));
				criteria.add(disjunction);
			}
			criteria.addOrder(Order.asc(Customer.PROP_FIRST_NAME).ignoreCase());

			List<Doctor> result = criteria.list();
			if (result == null || result.isEmpty()) {
				return null;
			}
			return result;
		}
	}

	public List<Doctor> findLabDoctor() {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(Doctor.class);

			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(Customer.PROP_ACTIVE, true));
			criteria.add(Restrictions.ilike(Customer.PROP_PROPERTIES, "\"doctor.lab\":\"" + true + "\"", MatchMode.ANYWHERE)); //$NON-NLS-1$ //$NON-NLS-2$
			criteria.addOrder(Order.asc(Customer.PROP_FIRST_NAME).ignoreCase());

			List<Doctor> result = criteria.list();
			if (result == null || result.isEmpty()) {
				return null;
			}
			return result;
		}
	}

	public List<Doctor> findDoctorsByAgent(String agentId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(Doctor.class);
			addDeletedFilter(criteria);
			criteria.add(Restrictions.ilike(Customer.PROP_PROPERTIES, "\"doctor.agent.id\":\"%" + agentId + "%\"", MatchMode.ANYWHERE)); //$NON-NLS-1$ //$NON-NLS-2$
			criteria.addOrder(Order.asc(Customer.PROP_FIRST_NAME).ignoreCase());
			return criteria.list();
		}
	}
}