/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.services.report;

import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportConstants;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.WeeklyPayrollReportData;
import com.floreantpos.report.WeeklyPayrollReportModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;

import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;

public class WeeklyPayrollReportService {

	private Date fromDate;
	private Date toDate;
	private User user;
	private int firstDayOfWeek;

	public WeeklyPayrollReportService() {
		super();
	}

	public WeeklyPayrollReportService(Date fromDate, Date toDate, User user, int firstDayOfWeek) {
		super();
		this.fromDate = fromDate;
		this.toDate = toDate;
		this.user = user;
		this.firstDayOfWeek = firstDayOfWeek;
	}

	public WeeklyPayrollReportModel findPayrollReportData() {

		Outlet outlet = DataProvider.get().getOutlet();
		DateUtil.validateDate(fromDate, toDate);
		//
		//		Calendar calendar = Calendar.getInstance();
		//		calendar.clear();
		//
		//		Calendar calendar2 = Calendar.getInstance();
		//		calendar2.setTime(fromDate);
		//
		//		calendar.set(Calendar.YEAR, calendar2.get(Calendar.YEAR));
		//		calendar.set(Calendar.MONTH, calendar2.get(Calendar.MONTH));
		//		calendar.set(Calendar.DATE, calendar2.get(Calendar.DATE));
		//		calendar.set(Calendar.HOUR, 0);
		//		calendar.set(Calendar.MINUTE, 0);
		//		calendar.set(Calendar.SECOND, 0);
		//		fromDate = calendar.getTime();
		//
		//		calendar.clear();
		//		calendar2.setTime(toDate);
		//		calendar.set(Calendar.YEAR, calendar2.get(Calendar.YEAR));
		//		calendar.set(Calendar.MONTH, calendar2.get(Calendar.MONTH));
		//		calendar.set(Calendar.DATE, calendar2.get(Calendar.DATE));
		//		calendar.set(Calendar.HOUR, 23);
		//		calendar.set(Calendar.MINUTE, 59);
		//		calendar.set(Calendar.SECOND, 59);
		//		toDate = calendar.getTime();

		List<WeeklyPayrollReportData> findPayroll = AttendenceHistoryDAO.getInstance().findWeeklyPayroll(fromDate, toDate, user, outlet, firstDayOfWeek);

		Comparator<WeeklyPayrollReportData> comparator = Comparator
				.comparing(WeeklyPayrollReportData::getFromDateOfWeek, Comparator.nullsLast(Comparator.naturalOrder()))
				.thenComparing(WeeklyPayrollReportData::getUserIdSortKey, Comparator.nullsLast(Comparator.naturalOrder()));
		findPayroll.sort(comparator);

		WeeklyPayrollReportModel reportModel = new WeeklyPayrollReportModel();
		reportModel.setRows(findPayroll);

		return reportModel;

	}

	public static JasperPrint createJasper(WeeklyPayrollReportModel reportModel, Date fromDate, Date toDate) {
		try {
			Outlet outlet = DataProvider.get().getOutlet();

			JasperReport report = ReportUtil.getReport(PaperSize.getReportNameAccording2Size(ReportConstants.WEEKLY_PAYROLL_REPORT));

			HashMap<String, Object> properties = new HashMap<String, Object>();
			ReportUtil.populateRestaurantProperties(properties, outlet);
			ReportUtil.populateReportTime(properties, fromDate, toDate);
			ReportUtil.populateReportFooter(properties);
			populateWeekLyReportParams(properties);

			JasperPrint print = JasperFillManager.fillReport(report, properties, new JRTableModelDataSource(reportModel));
			return print;
		} catch (PosException px) {
			POSMessageDialog.showError(POSUtil.getFocusedWindow(), px.getMessage());
		} catch (Exception e1) {
			POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e1);
		}
		return null;
	}

	private static void populateWeekLyReportParams(HashMap<String, Object> map) {
		map.put("RTitle", Messages.getString("WeeklyPayrollReportAction.0")); //$NON-NLS-1$ //$NON-NLS-2$
		map.put("colEID", Messages.getString("EmployeeId")); //$NON-NLS-1$ //$NON-NLS-2$
		map.put("colEName", Messages.getString("EmployeeName")); //$NON-NLS-1$ //$NON-NLS-2$
		map.put("colRole", Messages.getString("colRole")); //$NON-NLS-1$ //$NON-NLS-2$
		map.put("colRHW", Messages.getString("RegularH") + "<br/>" + Messages.getString("Worked")); //$NON-NLS-1$ //$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
		map.put("colOHW", Messages.getString("OvertimeH") + "<br/>" + Messages.getString("Worked")); //$NON-NLS-1$ //$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
		map.put("colRPay", Messages.getString("Regular") + "<br/>" + Messages.getString("PAYMENT")); //$NON-NLS-1$ //$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
		map.put("colOTPay", Messages.getString("OvertimeTH") + "<br/>" + Messages.getString("PAYMENT")); //$NON-NLS-1$ //$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
		map.put("colTHWork", Messages.getString("TotalH") + "<br/>" + Messages.getString("Worked")); //$NON-NLS-1$ //$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
		map.put("colTPay", POSConstants.TOTAL + "<br/>" + Messages.getString("PAYMENT")); //$NON-NLS-1$ //$NON-NLS-2$//$NON-NLS-3$
		map.put("colDTips", Messages.getString("declaredTips")); //$NON-NLS-1$ //$NON-NLS-2$
		map.put("colNCTips", Messages.getString("OtherTips")); //$NON-NLS-1$ //$NON-NLS-2$
	}
}
