package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;

public interface JsonPropertyContainer {
	public void setProperties (java.lang.String properties);
	public void updateProperties (java.lang.String properties);
	
	@JsonIgnore
	public abstract JsonObject getPropertyStore();

	public default boolean hasProperty(String key) {
		return this.getPropertyStore().has(key);
	}

	public default String getProperty(String key) {
		if (this.getPropertyStore().has(key)) {
			JsonElement jsonElement = this.getPropertyStore().get(key);
			if (jsonElement instanceof JsonNull) {
				return ""; //$NON-NLS-1$
			}
			return jsonElement.getAsString();
		}
		return null;
	}

	public default String getProperty(String key, String defaultValue) {
		if (this.getPropertyStore().has(key)) {
			JsonElement jsonElement = this.getPropertyStore().get(key);
			if (jsonElement instanceof JsonNull) {
				return ""; //$NON-NLS-1$
			}
			return jsonElement.getAsString();
		}
		return defaultValue;
	}

	public default Boolean getBooleanProperty(String key, boolean defaultValue) {
		JsonElement string = getPropertyStore().get(key);
		if (string == null) {
			return defaultValue;
		}
		return string.getAsBoolean();
	}

	public default double getDoubleProperty(String key) {
		return parseDouble(getProperty(key));
	}

	public default int getIntProperty(String key) {
		return (int) parseDouble(getProperty(key));
	}

	public default void addProperty(String key, String value) {
		JsonObject propertyStore = this.getPropertyStore();
		propertyStore.addProperty(key, value);
		
		updateProperties(propertyStore.toString());
	}

	public default void removeProperty(String propertyName) {
		JsonObject propertyStore = this.getPropertyStore();
		if (propertyStore != null) {
			propertyStore.remove(propertyName);
			updateProperties(propertyStore.toString());
		}
	}

	public static double parseDouble(String s) {
		if (StringUtils.isBlank(s)) {
			return 0;
		}

		try {
			return Double.parseDouble(s);
		} catch (Exception x) {
			return 0;
		}
	}
}
