package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseLedgerEntry;
import com.floreantpos.model.util.DataProvider;

public class LedgerEntry extends BaseLedgerEntry {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public LedgerEntry() {
	}

	/**
	 * Constructor for primary key
	 */
	public LedgerEntry(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public void setChartOfAccountDisplay() {

	}

	public String getChartOfAccountDisplay() {
		String cOAccountId = getAccountId();
		if (StringUtils.isBlank(cOAccountId)) {
			return "";
		}
		ChartOfAccounts chartOfAccounts = (ChartOfAccounts) DataProvider.get().getObjectOf(ChartOfAccounts.class, cOAccountId);
		if (chartOfAccounts == null) {
			return "";
		}
		return chartOfAccounts.getAccountName();
	}

	public String getDirectionDisplay() {
		Integer direction = getDirection();
		if (direction == 1) {
			return "Credit";
		}
		return "Debit";
	}

}