package com.floreantpos.model.dao;

import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.CashRegister;

public class CashRegisterDAO extends BaseCashRegisterDAO {

	public CashRegisterDAO() {
	}

	public List<CashRegister> findCashRegisters() {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(CashRegister.class);
			addDeletedFilter(criteria);
			criteria.add(Restrictions.isNotNull(CashRegister.PROP_NAME));
			criteria.add(Restrictions.ne(CashRegister.PROP_NAME, ""));

			criteria.addOrder(Order.asc(CashRegister.PROP_NAME).ignoreCase());
			return criteria.list();
		}
	}
}