package com.floreantpos.model.dao;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.COAAccountType;
import com.floreantpos.model.LedgerEntry;
import com.floreantpos.swing.PaginationSupport;

public class LedgerEntryDAO extends BaseLedgerEntryDAO {

	public void findByChartOfAcountName(PaginationSupport paginationSupport, String searchString) {
		try (Session session = createNewSession()) {

			Criteria criteria = session.createCriteria(LedgerEntry.class);
			addDeletedFilter(criteria);

			if (StringUtils.isNotBlank(searchString)) {
				DetachedCriteria detachedCriteria = DetachedCriteria.forClass(COAAccountType.class);
				detachedCriteria.setProjection(Property.forName(COAAccountType.PROP_ID));
				detachedCriteria.add(Restrictions.ilike(COAAccountType.PROP_NAME, searchString, MatchMode.ANYWHERE));

				criteria.add(Property.forName(LedgerEntry.PROP_ACCOUNT_ID).in(detachedCriteria)); //$NON-NLS-1$
			}
			criteria.setProjection(Projections.rowCount());

			Number rowCount = (Number) criteria.uniqueResult();
			if (rowCount != null) {
				paginationSupport.setNumRows(rowCount.intValue());
			}
			criteria.setProjection(null);
			paginationSupport.setRows(criteria.list());
		}
	}

}