package com.floreantpos.model.dao;

import java.util.Iterator;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.MenuItemInventoryStatus;

public class MenuItemInventoryStatusDAO extends BaseMenuItemInventoryStatusDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public MenuItemInventoryStatusDAO() {
	}
	
	public MenuItemInventoryStatus get(String menuItemId, String outletId) {
		try (Session session = createNewSession()) {
			return get(menuItemId, outletId, session);
		}
	}
	
	public MenuItemInventoryStatus get(String menuItemId, String outletId, Session session) {
		Criteria criteria = session.createCriteria(MenuItemInventoryStatus.class);
		criteria.add(Restrictions.eq(MenuItemInventoryStatus.PROP_MENU_ITEM_ID, menuItemId));
		criteria.add(Restrictions.eq(MenuItemInventoryStatus.PROP_OUTLET_ID, outletId));
		criteria.setMaxResults(1);
		
		MenuItemInventoryStatus status = (MenuItemInventoryStatus) criteria.uniqueResult();
		return status;
	}

	@Override
	public String save(MenuItemInventoryStatus menuItemInventoryStatus) throws HibernateException {
		validateData(menuItemInventoryStatus);
		menuItemInventoryStatus.setLastUpdateTime(StoreDAO.getServerTimestamp());
		return super.save(menuItemInventoryStatus);
	}

	@Override
	public String save(MenuItemInventoryStatus menuItemInventoryStatus, Session s) throws HibernateException {
		validateData(menuItemInventoryStatus);
		menuItemInventoryStatus.setLastUpdateTime(StoreDAO.getServerTimestamp());
		updateTime(menuItemInventoryStatus);
		return super.save(menuItemInventoryStatus, s);
	}

	@Override
	public void saveOrUpdate(MenuItemInventoryStatus menuItemInventoryStatus) throws HibernateException {
		validateData(menuItemInventoryStatus);
		menuItemInventoryStatus.setLastUpdateTime(StoreDAO.getServerTimestamp());
		super.saveOrUpdate(menuItemInventoryStatus);
	}

	@Override
	public void saveOrUpdate(MenuItemInventoryStatus menuItemInventoryStatus, Session s) throws HibernateException {
		validateData(menuItemInventoryStatus);
		
		menuItemInventoryStatus.setLastUpdateTime(StoreDAO.getServerTimestamp());
		updateTime(menuItemInventoryStatus);
		super.saveOrUpdate(menuItemInventoryStatus, s);
	}

	@Override
	public void update(MenuItemInventoryStatus menuItemInventoryStatus) throws HibernateException {
		validateData(menuItemInventoryStatus);
		
		menuItemInventoryStatus.setLastUpdateTime(StoreDAO.getServerTimestamp());
		super.update(menuItemInventoryStatus);
	}

	@Override
	public void update(MenuItemInventoryStatus menuItemInventoryStatus, Session s) throws HibernateException {
		validateData(menuItemInventoryStatus);
		
		menuItemInventoryStatus.setLastUpdateTime(StoreDAO.getServerTimestamp());
		updateTime(menuItemInventoryStatus);
		super.update(menuItemInventoryStatus, s);
	}

	public void saveOrUpdateMenuItemInventoryStatus(List<MenuItemInventoryStatus> dataList, String outletId, boolean updateLastUpdateTime, boolean updateSyncTime)
			throws Exception {

		if (dataList == null)
			return;

		Transaction tx = null;
		try (Session session = createNewSession()) {
			tx = session.beginTransaction();

			for (Iterator<MenuItemInventoryStatus> iterator = dataList.iterator(); iterator.hasNext();) {
				MenuItemInventoryStatus item = (MenuItemInventoryStatus) iterator.next();
				validateData(item);
				
				MenuItemInventoryStatus existingItem = get(item.getId(), outletId, session);
				if (existingItem != null) {
					long version = existingItem.getVersion();
					PropertyUtils.copyProperties(existingItem, item);
					existingItem.setVersion(version);
					existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
					existingItem.setUpdateSyncTime(updateSyncTime);
					update(existingItem, session);
				}
				else {
					item.setUpdateLastUpdateTime(updateLastUpdateTime);
					item.setUpdateSyncTime(updateSyncTime);
					save(item, session);
				}
			}
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		}
	}
	
	private void validateData(MenuItemInventoryStatus menuItemInventoryStatus) {
		if (StringUtils.isBlank(menuItemInventoryStatus.getOutletId())) {
			throw new RuntimeException("Outlet id is required"); //$NON-NLS-1$
		}
	}
}