package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BasePizzaCrust;

@XmlRootElement
public class PizzaCrust extends BasePizzaCrust implements TimedModel{
	private static final long serialVersionUID = 1L;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public PizzaCrust () {
    }

	/**
	 * Constructor for primary key
	 */
	public PizzaCrust (java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public String getTranslatedName() {
		String translatedName = super.getTranslatedName();
		if (StringUtils.isEmpty(translatedName)) {
			return getName();
		}

		return translatedName;
	}

	@Override
	public String toString() {
		return getName();
	}
}