package com.floreantpos.model.dao;

import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;

import com.floreantpos.model.ReservationShift;

public class ReservationShiftDAO extends BaseReservationShiftDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public ReservationShiftDAO() {
	}

	public void releaseParentAndDelete(ReservationShift reservationShift) {
		if (reservationShift == null) {
			return;
		}

		Session session = null;
		Transaction tx = null;

		try {
			session = createNewSession();
			tx = session.beginTransaction();
			session.delete(reservationShift);
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw new RuntimeException(e);
		} finally {
			closeSession(session);
		}
	}

	@Override
	public List<ReservationShift> findAll() {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			addDeletedFilter(criteria);
			return criteria.list();
		}
	}
}