package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseChartOfAccounts;
import com.floreantpos.model.util.DataProvider;

public class ChartOfAccounts extends BaseChartOfAccounts implements TimedModel {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public ChartOfAccounts() {
	}

	/**
	 * Constructor for primary key
	 */
	public ChartOfAccounts(java.lang.String id) {
		super(id);
	}

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER END]*/

	public String getCoaAccountTypeName() {
		String coaAccountTypeId = getCoaAccountTypeId();
		if (StringUtils.isBlank(coaAccountTypeId)) {
			return "";
		}
		COAAccountType coaAccountType = (COAAccountType) DataProvider.get().getObjectOf(COAAccountType.class, coaAccountTypeId);
		if (coaAccountType == null) {
			return "";
		}
		return coaAccountType.getName();
	}

	@Override
	public String toString() {
		return getAccountName();
	}

}