package com.floreantpos.model;

import java.util.Date;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseLedgerEntry;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;

public class LedgerEntry extends BaseLedgerEntry {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public LedgerEntry() {
	}

	/**
	 * Constructor for primary key
	 */
	public LedgerEntry(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public void setChartOfAccountDisplay() {

	}

	public String getChartOfAccountDisplay() {
		String cOAccountId = getAccountId();
		if (StringUtils.isBlank(cOAccountId)) {
			return "";
		}
		ChartOfAccounts chartOfAccounts = (ChartOfAccounts) DataProvider.get().getObjectOf(ChartOfAccounts.class, cOAccountId);
		if (chartOfAccounts == null) {
			return "";
		}
		return chartOfAccounts.getAccountName();
	}

	public double getCreditDirectionDisplay() {
		Integer direction = getDirection();
		if (DirectionType.DEBIT.getTypeNo() == direction) {
			return 0d;
		}
		return getAmount();
	}

	public double getDebitDirectionDisplay() {
		Integer direction = getDirection();
		if (DirectionType.CREDIT.getTypeNo() == direction) {
			return 0d;
		}
		return getAmount();
	}
	
	public String getDateDisplay() {
		String dateAsString = ""; //$NON-NLS-1$
		Date lastUpdateTime = getLastUpdateTime();
		if (lastUpdateTime == null) {
			return dateAsString;
		}
		return DateUtil.formatDateWithTime(lastUpdateTime);
	}

	public static LedgerEntry createLedgerEntry(Ticket ticket, ChartOfAccounts chartOfAccounts, DirectionType directionType, double remainLedgerAmount) {
		LedgerEntry ledgerEntry = new LedgerEntry();
		ledgerEntry.setCreateDate(StoreDAO.getServerTimestamp());
		ledgerEntry.setAccountId(chartOfAccounts.getId());
		if (ticket != null) {
			ledgerEntry.setTicketId(ticket.getId());
		}
		ledgerEntry.setAmount(Math.abs(remainLedgerAmount));
		int typeNo = remainLedgerAmount < 0 ? (-1) * directionType.getTypeNo() : directionType.getTypeNo();
		ledgerEntry.setDirection(typeNo);
		return ledgerEntry;
	}

}