package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseTestItem;
import com.floreantpos.model.util.DataProvider;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class TestItem extends BaseTestItem implements PropertyContainer {
	private static final long serialVersionUID = 1L;
	private transient JsonObject propertiesContainer;
	private transient TicketItem ticketItem;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public TestItem() {
	}

	/**
	 * Constructor for primary key
	 */
	public TestItem(java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public TestItem(java.lang.String id, java.lang.String name) {

		super(id, name);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public String toString() {
		return getName();
	}

	public void putTicketItem(TicketItem ticketItem) {
		this.ticketItem = ticketItem;
	}

	public TicketItem getTicketItem() {
		return ticketItem;

	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = null;
	}

	@Override
	public void addProperty(String key, String value) {
		initPropertyContainer();
		propertiesContainer.addProperty(key, value);
		super.setProperties(propertiesContainer.toString());
	}

	private void initPropertyContainer() {
		if (propertiesContainer == null) {
			if (StringUtils.isBlank(super.getProperties())) {
				propertiesContainer = new com.google.gson.JsonObject();
			}
			else {
				propertiesContainer = new Gson().fromJson(super.getProperties(), com.google.gson.JsonObject.class);
			}
		}
	}

	@Override
	public com.google.gson.JsonObject getPropertyStore() {
		initPropertyContainer();
		return propertiesContainer;
	}

	public void putInternalNote(String internalNote) {
		addProperty("internal.note", internalNote); //$NON-NLS-1$
	}

	public String getInternalNote() {
		return getProperty("internal.note", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public String getUnitName() {
		String unitId = getUnit();
		if (StringUtils.isBlank(unitId)) {
			return ""; //$NON-NLS-1$
		}
		InventoryUnit inventoryUnit = DataProvider.get().getInventoryUnitById(unitId);
		if (inventoryUnit != null) {
			return inventoryUnit.getName();
		}
		return ""; //$NON-NLS-1$
	}

	public String getTestItemGroupName() {
		if (StringUtils.isBlank(getTestItemGroupId())) {
			return "";
		}
		TestItemGroup testItemGroup = (TestItemGroup) DataProvider.get().getObjectOf(TestItemGroup.class, getTestItemGroupId());
		if (testItemGroup != null) {
			return testItemGroup.getName();
		}
		return "";
	}

}