package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the SHOP_TABLE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="SHOP_TABLE"
 */

public abstract class BaseShopTable  implements Comparable, Serializable {

	public static String REF = "ShopTable"; //$NON-NLS-1$
	public static String PROP_DESCRIPTION = "description"; //$NON-NLS-1$
	public static String PROP_SALES_AREA_ID = "salesAreaId"; //$NON-NLS-1$
	public static String PROP_FLOOR_ID = "floorId"; //$NON-NLS-1$
	public static String PROP_STATE_TABLE_TYPE = "stateTableType"; //$NON-NLS-1$
	public static String PROP_MIN_CAPACITY = "minCapacity"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_GLOBAL_ID = "globalId"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_RESERVABLE = "reservable"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_CAPACITY = "capacity"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_SHOP_TABLE_STATUS = "shopTableStatus"; //$NON-NLS-1$
	public static String PROP_X = "x"; //$NON-NLS-1$
	public static String PROP_Y = "y"; //$NON-NLS-1$
	public static String PROP_HEIGHT = "height"; //$NON-NLS-1$
	public static String PROP_CURRENT_BOOKING_ID = "currentBookingId"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_NAME = "customerName"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_WIDTH = "width"; //$NON-NLS-1$


	// constructors
	public BaseShopTable () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseShopTable (
		java.lang.Integer id,
		java.lang.String outletId) {

		this.setId(id);
		this.setOutletId(outletId);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseShopTable (
		java.lang.Integer id,
		java.lang.String outletId,
		java.lang.String globalId) {

		this.setId(id);
		this.setOutletId(outletId);
		this.setGlobalId(globalId);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key

	private java.lang.Integer id;

	private java.lang.String outletId;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String globalId;
				private java.lang.String name;
				private java.lang.String description;
				private java.lang.Integer capacity;
				private java.lang.Integer minCapacity;
				private java.lang.Integer x;
				private java.lang.Integer y;
				private java.lang.Integer width;
				private java.lang.Integer height;
				private java.lang.Integer stateTableType;
				private java.lang.Boolean reservable;
				private java.lang.String salesAreaId;
				private java.lang.String floorId;
				private java.lang.String currentBookingId;
				private java.lang.String customerName;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
	
	// many to one
	private com.floreantpos.model.ShopTableStatus shopTableStatus;

	// collections
	private java.util.List<com.floreantpos.model.ShopTableType> types;
	private java.util.Set<com.floreantpos.model.ShopSeat> seats;



	/**
     * @hibernate.property
     *  column=ID
	 * not-null=true
	 */
	public java.lang.Integer getId () {
		return this.id;
	}

	/**
	 * Set the value related to the column: ID
	 * @param id the ID value
	 */
	public void setId (java.lang.Integer id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}

	/**
     * @hibernate.property
     *  column=OUTLET_ID
	 * not-null=true
	 */
	public java.lang.String getOutletId () {
		return this.outletId;
	}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
	public void setOutletId (java.lang.String outletId) {
		this.outletId = outletId;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: GLOBAL_ID
	 */

	public java.lang.String getGlobalId () {
			return globalId;
	}



	/**
	 * Set the value related to the column: GLOBAL_ID
	 * @param globalId the GLOBAL_ID value
	 */
			public void setGlobalId (java.lang.String globalId) {
			this.globalId = globalId;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: DESCRIPTION
	 */

	public java.lang.String getDescription () {
			return description;
	}



	/**
	 * Set the value related to the column: DESCRIPTION
	 * @param description the DESCRIPTION value
	 */
			public void setDescription (java.lang.String description) {
			this.description = description;
	}



	/**
	 * Return the value associated with the column: CAPACITY
	 */

	public java.lang.Integer getCapacity () {
						return capacity == null ? Integer.valueOf(0) : capacity;
		}



	/**
	 * Set the value related to the column: CAPACITY
	 * @param capacity the CAPACITY value
	 */
			public void setCapacity (java.lang.Integer capacity) {
			this.capacity = capacity;
	}



	/**
	 * Return the value associated with the column: MIN_CAPACITY
	 */

	public java.lang.Integer getMinCapacity () {
						return minCapacity == null ? Integer.valueOf(0) : minCapacity;
		}



	/**
	 * Set the value related to the column: MIN_CAPACITY
	 * @param minCapacity the MIN_CAPACITY value
	 */
			public void setMinCapacity (java.lang.Integer minCapacity) {
			this.minCapacity = minCapacity;
	}



	/**
	 * Return the value associated with the column: X
	 */

	public java.lang.Integer getX () {
						return x == null ? Integer.valueOf(0) : x;
		}



	/**
	 * Set the value related to the column: X
	 * @param x the X value
	 */
			public void setX (java.lang.Integer x) {
			this.x = x;
	}



	/**
	 * Return the value associated with the column: Y
	 */

	public java.lang.Integer getY () {
						return y == null ? Integer.valueOf(0) : y;
		}



	/**
	 * Set the value related to the column: Y
	 * @param y the Y value
	 */
			public void setY (java.lang.Integer y) {
			this.y = y;
	}



	/**
	 * Return the value associated with the column: WIDTH
	 */

	public java.lang.Integer getWidth () {
						return width == null ? Integer.valueOf(0) : width;
		}



	/**
	 * Set the value related to the column: WIDTH
	 * @param width the WIDTH value
	 */
			public void setWidth (java.lang.Integer width) {
			this.width = width;
	}



	/**
	 * Return the value associated with the column: HEIGHT
	 */

	public java.lang.Integer getHeight () {
						return height == null ? Integer.valueOf(0) : height;
		}



	/**
	 * Set the value related to the column: HEIGHT
	 * @param height the HEIGHT value
	 */
			public void setHeight (java.lang.Integer height) {
			this.height = height;
	}



	/**
	 * Return the value associated with the column: STATE_TABLE_TYPE
	 */

	public java.lang.Integer getStateTableType () {
						return stateTableType == null ? Integer.valueOf(0) : stateTableType;
		}



	/**
	 * Set the value related to the column: STATE_TABLE_TYPE
	 * @param stateTableType the STATE_TABLE_TYPE value
	 */
			public void setStateTableType (java.lang.Integer stateTableType) {
			this.stateTableType = stateTableType;
	}



	/**
	 * Return the value associated with the column: RESERVABLE
	 */

	public java.lang.Boolean isReservable () {
						return reservable == null ? Boolean.valueOf(true) : reservable;
			}

	public java.lang.Boolean getReservable () {
					return reservable == null ? Boolean.valueOf(true) : reservable;
			}


	/**
	 * Set the value related to the column: RESERVABLE
	 * @param reservable the RESERVABLE value
	 */
			public void setReservable (java.lang.Boolean reservable) {
			this.reservable = reservable;
	}


	/**
	 * Custom property
	 */
	public static String getReservableDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: SALES_AREA_ID
	 */

	public java.lang.String getSalesAreaId () {
			return salesAreaId;
	}



	/**
	 * Set the value related to the column: SALES_AREA_ID
	 * @param salesAreaId the SALES_AREA_ID value
	 */
			public void setSalesAreaId (java.lang.String salesAreaId) {
			this.salesAreaId = salesAreaId;
	}



	/**
	 * Return the value associated with the column: FLOOR_ID
	 */

	public java.lang.String getFloorId () {
			return floorId;
	}



	/**
	 * Set the value related to the column: FLOOR_ID
	 * @param floorId the FLOOR_ID value
	 */
			public void setFloorId (java.lang.String floorId) {
			this.floorId = floorId;
	}



	/**
	 * Return the value associated with the column: CURRENT_BOOKING_ID
	 */

	public java.lang.String getCurrentBookingId () {
			return currentBookingId;
	}



	/**
	 * Set the value related to the column: CURRENT_BOOKING_ID
	 * @param currentBookingId the CURRENT_BOOKING_ID value
	 */
			public void setCurrentBookingId (java.lang.String currentBookingId) {
			this.currentBookingId = currentBookingId;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_NAME
	 */

	public java.lang.String getCustomerName () {
			return customerName;
	}



	/**
	 * Set the value related to the column: CUSTOMER_NAME
	 * @param customerName the CUSTOMER_NAME value
	 */
			public void setCustomerName (java.lang.String customerName) {
			this.customerName = customerName;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: STATUS_OUTLET_ID
	 */

	public com.floreantpos.model.ShopTableStatus getShopTableStatus () {
			return shopTableStatus;
	}



	/**
	 * Set the value related to the column: STATUS_OUTLET_ID
	 * @param shopTableStatus the STATUS_OUTLET_ID value
	 */
			public void setShopTableStatus (com.floreantpos.model.ShopTableStatus shopTableStatus) {
			this.shopTableStatus = shopTableStatus;
	}



	/**
	 * Return the value associated with the column: types
	 */

	public java.util.List<com.floreantpos.model.ShopTableType> getTypes () {
			return types;
	}



	/**
	 * Set the value related to the column: types
	 * @param types the types value
	 */
			public void setTypes (java.util.List<com.floreantpos.model.ShopTableType> types) {
			this.types = types;
	}

	public void addTotypes (com.floreantpos.model.ShopTableType shopTableType) {
		if (null == getTypes()) setTypes(new java.util.ArrayList<com.floreantpos.model.ShopTableType>());
		getTypes().add(shopTableType);
	}



	/**
	 * Return the value associated with the column: seats
	 */

	public java.util.Set<com.floreantpos.model.ShopSeat> getSeats () {
			return seats;
	}



	/**
	 * Set the value related to the column: seats
	 * @param seats the seats value
	 */
			public void setSeats (java.util.Set<com.floreantpos.model.ShopSeat> seats) {
			this.seats = seats;
	}

	public void addToseats (com.floreantpos.model.ShopSeat shopSeat) {
		if (null == getSeats()) setSeats(new java.util.TreeSet<com.floreantpos.model.ShopSeat>());
		getSeats().add(shopSeat);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;//abcd
		if (!(obj instanceof com.floreantpos.model.ShopTable)) return false;
		else {
			com.floreantpos.model.ShopTable shopTable = (com.floreantpos.model.ShopTable) obj;
			if (null != this.getId() && null != shopTable.getId()) {
				if (!this.getId().equals(shopTable.getId())) {
					return false;
				}
			}
			else {
				return false;
			}
			if (null != this.getOutletId() && null != shopTable.getOutletId()) {
				if (!this.getOutletId().equals(shopTable.getOutletId())) {
					return false;
				}
			}
			else {
				return false;
			}
			return true;
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			StringBuilder sb = new StringBuilder();
			if (null != this.getId()) {
				sb.append(this.getId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			if (null != this.getOutletId()) {
				sb.append(this.getOutletId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			this.hashCode = sb.toString().hashCode();
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}