package com.floreantpos.model.util.pricecalc;

import java.lang.reflect.Method;

import com.floreantpos.model.TicketItem;

public class TicketItemModifierCalcFactory {
	private static TicketItemModifierCalc calcV1;
	private static TicketItemModifierCalc calcV2;
	
	public static TicketItemModifierCalc geCalc(TicketItem ticketItem) {
		try {
			if (ticketItem == null || ticketItem.getDataVersion() >= 2) {
				if (calcV2 != null) {
					return calcV2;
				}
				
				Class<?> clazz = Class.forName("com.orocube.pos.pricecalc.TicketItemModifierPriceCalcV2"); //$NON-NLS-1$
				Method method = clazz.getMethod("getInstance"); //$NON-NLS-1$
				calcV2 = (TicketItemModifierCalc) method.invoke(null);
				return calcV2;
			}
			else {
				if (calcV1 != null) {
					return calcV1;
				}

				Class<?> clazz = Class.forName("com.orocube.pos.pricecalc.TicketItemModifierPriceCalcV1"); //$NON-NLS-1$
				Method method = clazz.getMethod("getInstance"); //$NON-NLS-1$
				calcV1 = (TicketItemModifierCalc) method.invoke(null);
				return calcV1;
			} 
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

}
