package com.floreantpos.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.io.IOUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

import com.floreantpos.PosLog;
import com.floreantpos.model.COAAccountType;
import com.floreantpos.model.COAAccountTypeGroup;
import com.floreantpos.model.ChartOfAccounts;
import com.floreantpos.model.dao.COAAccountTypeDAO;
import com.floreantpos.model.dao.COAAccountTypeGroupDAO;
import com.floreantpos.model.dao.ChartOfAccountsDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

public class DefaultCOADataInserter {

	private String defaultOutletId;

	public DefaultCOADataInserter(String defaultOutletId) {
		this.defaultOutletId = defaultOutletId;
	}

	public void insert() {
		Transaction transaction = null;
		try (Session session = GenericDAO.getInstance().createNewSession()) {
			transaction = session.beginTransaction();

			Map<COAAccountTypeGroup, List<COAAccountType>> defaultCOATypeMap = createDefaultCOAType();
			for (Map.Entry<COAAccountTypeGroup, List<COAAccountType>> entry : defaultCOATypeMap.entrySet()) {
				COAAccountTypeGroup group = entry.getKey();
				List<COAAccountType> types = entry.getValue();

				COAAccountTypeGroupDAO.getInstance().save(group, session);
				for (COAAccountType coaAccountType : types) {
					COAAccountTypeDAO.getInstance().save(coaAccountType, session);
				}
			}

			List<ChartOfAccounts> chartOfAccounts = createDefaultCOAData();
			for (ChartOfAccounts chartOfAccount : chartOfAccounts) {
				ChartOfAccountsDAO.getInstance().save(chartOfAccount, session);
			}

			transaction.commit();
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}
	}

	private Map<COAAccountTypeGroup, List<COAAccountType>> createDefaultCOAType() {
		Map<COAAccountTypeGroup, List<COAAccountType>> coaMap = new HashMap<>();
		//Asset group
		COAAccountTypeGroup assetGroup = new COAAccountTypeGroup("asset", "Asset");
		assetGroup.setAccountDirection(1);

		COAAccountType currentAssetType = new COAAccountType("current_asset", "Current asset");
		currentAssetType.setCoaAccountTypeGroupId("asset");

		COAAccountType fixedAssetType = new COAAccountType("fixed_asset", "Fixed asset");
		fixedAssetType.setCoaAccountTypeGroupId("asset");

		COAAccountType inventoryType = new COAAccountType("inventory", "Inventory");
		inventoryType.setCoaAccountTypeGroupId("asset");

		COAAccountType nonCurrentAssetType = new COAAccountType("non_current_asset", "Non-current asset");
		nonCurrentAssetType.setCoaAccountTypeGroupId("asset");

		COAAccountType prepaymentType = new COAAccountType("prepayment", "Prepayment");
		prepaymentType.setCoaAccountTypeGroupId("asset");

		coaMap.put(assetGroup, Arrays.asList(currentAssetType, fixedAssetType, inventoryType, nonCurrentAssetType, prepaymentType));

		//Equity group
		COAAccountTypeGroup equityGroup = new COAAccountTypeGroup("equity", "Equity");
		equityGroup.setAccountDirection(1);

		COAAccountType equityType = new COAAccountType("equity", "Equity");
		equityType.setCoaAccountTypeGroupId("equity");

		coaMap.put(equityGroup, Arrays.asList(equityType));

		//Expense group
		COAAccountTypeGroup expenseGroup = new COAAccountTypeGroup("expense", "Expense");
		expenseGroup.setAccountDirection(-1);

		COAAccountType depreciationType = new COAAccountType("depreciation", "Depreciation");
		depreciationType.setCoaAccountTypeGroupId("expense");

		COAAccountType directCostsType = new COAAccountType("direct_costs", "Direct costs");
		directCostsType.setCoaAccountTypeGroupId("expense");

		COAAccountType expenseType = new COAAccountType("expense", "Expense");
		expenseType.setCoaAccountTypeGroupId("expense");

		COAAccountType overheadType = new COAAccountType("overhead", "Overhead");
		overheadType.setCoaAccountTypeGroupId("expense");

		coaMap.put(expenseGroup, Arrays.asList(depreciationType, directCostsType, expenseType, overheadType));

		//Liabilities group
		COAAccountTypeGroup liabilitiesGroup = new COAAccountTypeGroup("liabilities", "Liabilities");
		liabilitiesGroup.setAccountDirection(-1);

		COAAccountType currentLiabilityType = new COAAccountType("current_liability", "Current liability");
		currentLiabilityType.setCoaAccountTypeGroupId("liabilities");

		COAAccountType liabilityType = new COAAccountType("liability", "Liability");
		liabilityType.setCoaAccountTypeGroupId("liabilities");

		COAAccountType nonCurrentLiabilityType = new COAAccountType("non_current_liability", "Non-current liability");
		nonCurrentLiabilityType.setCoaAccountTypeGroupId("liabilities");

		coaMap.put(liabilitiesGroup, Arrays.asList(currentLiabilityType, liabilityType, nonCurrentLiabilityType));

		//Revenue group
		COAAccountTypeGroup revenueGroup = new COAAccountTypeGroup("revenue", "Revenue");
		revenueGroup.setAccountDirection(1);

		COAAccountType otherIncomeType = new COAAccountType("other_income", "Other income");
		otherIncomeType.setCoaAccountTypeGroupId("revenue");

		COAAccountType revenueType = new COAAccountType("revenue", "Revenue");
		revenueType.setCoaAccountTypeGroupId("revenue");

		COAAccountType salesType = new COAAccountType("sales", "Sales");
		salesType.setCoaAccountTypeGroupId("revenue");

		coaMap.put(revenueGroup, Arrays.asList(otherIncomeType, revenueType, salesType));

		return coaMap;
	}

	private List<ChartOfAccounts> createDefaultCOAData() {
		List<ChartOfAccounts> chartOfAccounts = null;
		try (InputStream resourceAsStream = DefaultCOADataInserter.class.getResourceAsStream("/ChartOfAccounts.json")) {
			if (resourceAsStream != null) {
				Type listType = new TypeToken<ArrayList<ChartOfAccounts>>() {
				}.getType();

				chartOfAccounts = new Gson().fromJson(IOUtils.toString(resourceAsStream), listType);
			}
		} catch (IOException e) {
			PosLog.error(getClass(), e);
		}
		return chartOfAccounts;
	}

}
