package com.floreantpos.util;

import java.text.SimpleDateFormat;

import org.hibernate.Session;

import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketItemDAO;

public class LabTestIdGenerator {
	private static SimpleDateFormat yearMonthDay = new SimpleDateFormat("yyMMdd"); //$NON-NLS-1$

	//	@Override
	//	public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
	//		Class<? extends Object> clazz = object.getClass();
	//		Serializable generatedId = null;
	//		try {
	//			Method method = clazz.getMethod("getId", (Class<?>[]) null); //$NON-NLS-1$
	//			if (method != null) {
	//				Object id = method.invoke(object, (Object[]) null);
	//				if (id != null) {
	//					generatedId = (Serializable) id;
	//				}
	//			}
	//
	//			if (generatedId == null) {
	//				generatedId = generateLabTestId((Session) session);
	//			}
	//		} catch (Exception e) {
	//			PosLog.error(LabTestIdGenerator.class, e);
	//		}
	//
	//		return generatedId;
	//	}
	//

	public static String generateLabTestId() {
		try (Session session = GenericDAO.getInstance().createNewSession()) {
			String labTestId = generateLabTestId(session);
			while (TicketItemDAO.getInstance().findByLabTest(labTestId, session) != null) {
				labTestId = generateLabTestId(session);
			}
			return labTestId;
		}
	}

	public static String generateLabTestId(Session session) {
		return yearMonthDay.format(StoreDAO.getServerTimestamp()) + getSequenceNumber(session);
	}

	private static String getSequenceNumber(Session session) {
		if (session == null) {
			return ""; //$NON-NLS-1$
		}
		int nextSequenceNumber = SequenceNumberDAO.getInstance().getNextSequenceNumber(SequenceNumber.LAB_TEST_SEQUENCE_NUMBER, session);
		return nextSequenceNumber + ""; //$NON-NLS-1$
	}

}
