package com.floreantpos.model.dao;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.OrderHistory;
import com.floreantpos.swing.PaginationSupport;

public class OrderHistoryDAO extends BaseOrderHistoryDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public OrderHistoryDAO() {
	}

	@SuppressWarnings("unchecked")
	public List<OrderHistory> findOrdersByCustomerId(String customerId) {
		if (StringUtils.isBlank(customerId)) {
			return new ArrayList<>(0);
		}

		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(OrderHistory.class);
			criteria.add(Restrictions.eq(OrderHistory.PROP_CUSTOMER_ID, customerId));
			criteria.add(Restrictions.isNotNull(OrderHistory.PROP_TICKET_JSON));
			criteria.addOrder(Order.desc(OrderHistory.PROP_ORDER_DATE));
			criteria.setMaxResults(50);

			return criteria.list();
		}
	}

	public void loadOrdersByCustomerId(PaginationSupport tableModel, String customerId) {
		if (StringUtils.isBlank(customerId)) {
			tableModel.setNumRows(0);
			tableModel.setRows(new ArrayList<>());
			return;
		}
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(OrderHistory.class);
			criteria.setProjection(Projections.rowCount());
			criteria.add(Restrictions.eq(OrderHistory.PROP_CUSTOMER_ID, customerId));
			criteria.add(Restrictions.isNotNull(OrderHistory.PROP_TICKET_JSON));
			Number result = (Number) criteria.uniqueResult();
			int rowCount = result == null ? 0 : result.intValue();
			tableModel.setNumRows(rowCount);
			if (rowCount == 0) {
				tableModel.setRows(new ArrayList<>());
				return;
			}
			criteria.setProjection(null);
			criteria.addOrder(Order.desc(OrderHistory.PROP_ORDER_DATE));
			criteria.setFirstResult(tableModel.getCurrentRowIndex());
			criteria.setMaxResults(tableModel.getPageSize());
			tableModel.setRows(criteria.list());
		}
	}
}