/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

import com.floreantpos.PosLog;

public class UpdateDBTo303 {

	private SessionFactory sessionFactory;
	private String schemaName;

	public UpdateDBTo303(SessionFactory sessionFactory, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void update() throws Exception {
		PosLog.info(getClass(), "Updating " + schemaName + " schema.");
		try (Session session = sessionFactory.openSession()) {
			Transaction transaction = session.beginTransaction();
			String menuModifierQuery = "update %s.menu_modifier m set enable = true";
			PosLog.info(getClass(), menuModifierQuery);
			SQLQuery query = session.createSQLQuery(String.format(menuModifierQuery, schemaName));
			int update = query.executeUpdate();
			transaction.commit();
			PosLog.info(getClass(), schemaName + ": updated " + update + " row");
		}
	}
}