package com.floreantpos.model.util.pricecalc;

import java.math.BigDecimal;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItemDiscount;

public interface DiscountCalculator {
	
	double calculateDiscount(TicketItemDiscount ticketItemDiscount, double subtotalAmount);

	double calculatePercentageForTotal(Double value, Double totalAmount);

	Double calculateDiscountPercentageFromAmount(Double subtotalAmount, Double value);

	BigDecimal calculateDiscountAmount(TicketItemDiscount percentDiscount, BigDecimal subtotal);

	Double calculateRepriceDiscount(Ticket ticket, Double value);

	Double calculateDiscountAmount(double ticketSubTotal, TicketDiscount ticketDiscount);

}
