package com.floreantpos.model.ext;

import com.floreantpos.model.TicketItem;

public class InvMapKey {
	/**
	 * 
	 */
	TicketItem ticketItem;
	String menuItemId;
	String unitId;
	boolean itemReturned;
	
	public InvMapKey(String menuItemId, String unitId) {
		super();
		this.menuItemId = menuItemId;
		this.unitId = unitId;
	}
	
	public InvMapKey(TicketItem ticketItem) {
		super();
		this.ticketItem = ticketItem;
		this.menuItemId = ticketItem.getMenuItemId();
		this.unitId = ticketItem.getUnitName();
	}

	public String getMenuItemId() {
		return menuItemId;
	}

	public String getUnitId() {
		return unitId;
	}
	
	public TicketItem getTicketItem() {
		return ticketItem;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((menuItemId == null) ? 0 : menuItemId.hashCode());
		result = prime * result + ((unitId == null) ? 0 : unitId.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		InvMapKey other = (InvMapKey) obj;
		if (menuItemId == null) {
			if (other.menuItemId != null)
				return false;
		}
		else if (!menuItemId.equals(other.menuItemId))
			return false;
		if (unitId == null) {
			if (other.unitId != null)
				return false;
		}
		else if (!unitId.equals(other.unitId))
			return false;
		return true;
	}

	public boolean isItemReturned() {
		return itemReturned;
	}

	public void setItemReturned(boolean itemReturned) {
		this.itemReturned = itemReturned;
	}

}