package com.floreantpos.report.model;

import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;

public class IncomeStatementReportModel extends ListTableModel {
	public IncomeStatementReportModel() {
		super(new String[] { "operatingExpenses", "operatingExpensesAmount" });
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		BalanceSheetLedgerEntryModel reportData = (BalanceSheetLedgerEntryModel) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return reportData.getCoaName();

			case 1:
				return  NumberUtil.formatToAccountingAmount(reportData.getAmount()* (-1));

		}
		return null;
	}

}