package com.floreantpos.report;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.Customer;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.NumberUtil;

public class SalesDetailsReportData implements Serializable {

	private String outletId;
	private String agentName;
	private String orderId;
	private Date orderDate;
	private String patientName;
	private String orderDateDisplay;
	private double grossSales;
	private double discount;
	private double refund;
	private double agentFee;
	private double labDoctorFee;
	private double netSales;

	public SalesDetailsReportData(Ticket ticket) {
		String referrerId = ticket.getReferrerId();
		if (StringUtils.isNotBlank(referrerId)) {
			Customer referrer = CustomerDAO.getInstance().get(referrerId);
			if (referrer != null) {
				setAgentName(referrer.getName());
			}
		}
		setOrderId(ticket.getId());
		setOutletId(ticket.getOutletId());
		setOrderDate(ticket.getCreateDate());
		Customer customer = ticket.getCustomer();
		if (customer != null) {
			setPatientName(customer.getName());
		}
		setGrossSales(ticket.getSubtotalAmount());
		setDiscount(ticket.getDiscountAmount());
		setRefund(ticket.getRefundAmount());
		setAgentFee(ticket.getTotalReferrerFee());
		setlabDoctorFee(ticket.getLabDoctorFee());

		setNetSales(grossSales - (discount + refund + agentFee + labDoctorFee));
	}

	public String getPatientName() {
		return patientName;
	}

	public void setPatientName(String patientName) {
		this.patientName = patientName;
	}

	public double getAgentFee() {
		return agentFee;
	}

	public void setAgentFee(double agentFee) {
		this.agentFee = agentFee;
	}

	public String getOutletId() {
		return outletId;
	}

	public void setOutletId(String outletId) {
		this.outletId = outletId;
	}

	public String getAgentName() {
		return agentName;
	}

	public void setAgentName(String agentName) {
		this.agentName = agentName;
	}

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public Date getOrderDate() {
		return orderDate;
	}

	public void setOrderDate(Date orderDate) {
		this.orderDate = orderDate;
	}

	public double getGrossSales() {
		return grossSales;
	}

	public void setGrossSales(double grossSales) {
		this.grossSales = grossSales;
	}

	public double getDiscount() {
		return discount;
	}

	public void setDiscount(double discount) {
		this.discount = discount;
	}

	public double getRefund() {
		return refund;
	}

	public void setRefund(double refund) {
		this.refund = refund;
	}

	public double getlabDoctorFee() {
		return labDoctorFee;
	}

	public void setlabDoctorFee(double labDrFee) {
		this.labDoctorFee = labDrFee;
	}

	public String getOrderDateDisplay() {
		return DateUtil.formatDateWithTime(DateUtil.convertServerTimeToBrowserTime(getOrderDate()));
	}

	public void setOrderDateDisplay(String orderDateDisplay) {
	}

	public double getNetSales() {
		return netSales;
	}

	public void setNetSales(double netSales) {
		this.netSales = netSales;
	}
}
