package com.floreantpos.model.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.util.AESencrp;

public class GeneratePasswordUtil {

	public GeneratePasswordUtil() {

	}

	public String createRandPass(String passWordLength) throws Exception {
		List<String> passList = new ArrayList<String>();
		List<String> passwords = UserDAO.getInstance().findUsersPasswords();
		for (Iterator iterator = passwords.iterator(); iterator.hasNext();) {
			String string = (String) iterator.next();
			if (StringUtils.isEmpty(string)) {
				iterator.remove();
				continue;
			}
			String deCryptedPass = AESencrp.decrypt(string);
			passList.add(deCryptedPass);
		}
		String rawString = "1234567890"; //$NON-NLS-1$
		StringBuilder stringBuilder = new StringBuilder();
		String password = genPassword(rawString, stringBuilder, passWordLength);
		while (passList.contains(password)) {
			stringBuilder.setLength(0);
			password = genPassword(rawString, stringBuilder, passWordLength);
		}
		return password;
	}

	private String genPassword(String rawString, StringBuilder stringBuilder, String passWordLength) {
		Random rand = new Random();
		String password = ""; //$NON-NLS-1$
		if (passWordLength.length() == 0) {
			while (stringBuilder.length() < 4) {
				int index = (int) (rand.nextFloat() * rawString.length());
				stringBuilder.append(rawString.charAt(index));
			}
			password = stringBuilder.toString();
		}
		else {
			while (stringBuilder.length() < Integer.parseInt(passWordLength)) {
				int index = (int) (rand.nextFloat() * rawString.length());
				stringBuilder.append(rawString.charAt(index));
			}
			password = stringBuilder.toString();
		}
		return password;
	}

	public String createRandomCustomerId(int passWordLength) {
		String rawString = "1234567890"; //$NON-NLS-1$
		StringBuilder stringBuilder = new StringBuilder();
		String userId = genUserId(rawString, stringBuilder, passWordLength);
		while (UserDAO.getInstance().isUserExist(userId)) {
			stringBuilder.setLength(0);
			userId = genUserId(rawString, stringBuilder, passWordLength);
		}
		return userId;
	}

	private String genUserId(String rawString, StringBuilder stringBuilder, int passWordLength) {
		Random rand = new Random();
		String password = ""; //$NON-NLS-1$
		if (passWordLength == 0) {
			while (stringBuilder.length() < 5) {
				int index = (int) (rand.nextFloat() * rawString.length());
				stringBuilder.append(rawString.charAt(index));
			}
			password = stringBuilder.toString();
		}
		else {
			while (stringBuilder.length() < passWordLength) {
				int index = Math.abs((int) (rand.nextDouble() * 10));
				if (stringBuilder.length() == 0 && index > 0) {
					stringBuilder.append(index);
				}
				else if (stringBuilder.length() > 0) {
					stringBuilder.append(index);
				}
			}
			password = stringBuilder.toString();
		}
		return password;
	}

}
