package com.floreantpos.util;

import java.text.SimpleDateFormat;

import org.hibernate.Session;

import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;

public class UserIdGenerator {
	private static SimpleDateFormat yearMonthDay = new SimpleDateFormat("yyMMdd"); //$NON-NLS-1$

	public static String generateUserId() {
		try (Session session = GenericDAO.getInstance().createNewSession()) {
			String userId = generateUserId(session);
			String currentOutletId = DataProvider.get().getCurrentOutletId();
			while (UserDAO.getInstance().get(userId, currentOutletId, session) != null) {
				userId = generateUserId(session);
			}
			return userId;
		}
	}

	private static String generateUserId(Session session) {
		return yearMonthDay.format(StoreDAO.getServerTimestamp()) + getSequenceNumber(session);
	}

	private static String getSequenceNumber(Session session) {
		if (session == null) {
			return ""; //$NON-NLS-1$
		}
		int nextSequenceNumber = SequenceNumberDAO.getInstance().getNextSequenceNumber(SequenceNumber.USER_ID_SEQUENCE_NUMBER, session);
		return nextSequenceNumber + ""; //$NON-NLS-1$
	}

}
