package com.floreantpos.model.dao;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.TestItemGroup;
import com.floreantpos.swing.PaginationSupport;

public class TestItemGroupDAO extends BaseTestItemGroupDAO {
	@Override
	protected void delete(Object obj, Session s) {
		TestItemGroup testItemGroup = (TestItemGroup) obj;
		testItemGroup.setDeleted(true);
		update(testItemGroup, s);
	}

	public void findByName(PaginationSupport tableModel, String searchString) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(TestItemGroup.class);

			addDeletedFilter(criteria);
			criteria.add(Restrictions.ilike(TestItemGroup.PROP_NAME, searchString, MatchMode.ANYWHERE));

			tableModel.setNumRows(rowCount(criteria));

			criteria.setFirstResult(tableModel.getCurrentRowIndex());
			criteria.setMaxResults(tableModel.getPageSize());
			criteria.addOrder(Order.asc(TestItemGroup.PROP_NAME).ignoreCase());
			criteria.addOrder(Order.asc(TestItemGroup.PROP_SORT_ORDER));
			tableModel.setRows(criteria.list());
		}
	}

	public TestItemGroup findByName(String groupName) {
		try (Session session = createNewSession()) {
			return findByName(groupName, session);
		}
	}

	public TestItemGroup findByName(String groupName, Session session) {
		Criteria criteria = session.createCriteria(TestItemGroup.class);

		addDeletedFilter(criteria);
		criteria.add(Restrictions.eq(TestItemGroup.PROP_NAME, groupName).ignoreCase());
		criteria.setMaxResults(1);
		return (TestItemGroup) criteria.uniqueResult();
	}

}