package com.floreantpos.model.ext;

import com.floreantpos.Messages;

public enum CardTypeEnum {

    VISA(Messages.getString("CardTypeEnum.0")), //$NON-NLS-1$
    MASTER_CARD(Messages.getString("CardTypeEnum.1")), //$NON-NLS-1$
    AMERICAN_EXPRESS(Messages.getString("CardTypeEnum.2")), //$NON-NLS-1$
    DISCOVER(Messages.getString("CardTypeEnum.3")), //$NON-NLS-1$
    JCB(Messages.getString("CardTypeEnum.4")), //$NON-NLS-1$
    DINERS_CLUB(Messages.getString("CardTypeEnum.5")); //$NON-NLS-1$
    private final String value;

    CardTypeEnum(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static CardTypeEnum fromValue(String v) {
        for (CardTypeEnum c: CardTypeEnum.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}