package com.floreantpos.model.dao;

import java.io.Serializable;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.GlobalConfig;
import com.floreantpos.util.POSUtil;

public class GlobalConfigDAO extends BaseGlobalConfigDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public GlobalConfigDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public void addProperty(String key, String value) {
		GlobalConfig globalConfig = findByKey(key);
		if (globalConfig == null) {
			globalConfig = new GlobalConfig();
			globalConfig.setKey(key);
		}
		globalConfig.setValue(value);
		saveOrUpdate(globalConfig);
	}

	public String getProperty(String key) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.setProjection(Projections.property(GlobalConfig.PROP_VALUE));
			criteria.add(Restrictions.eq(GlobalConfig.PROP_KEY, key));
			return (String) criteria.uniqueResult();
		}
	}

	public String getProperty(String key, String defaultValue) {
		String propValue = getProperty(key);
		if (StringUtils.isBlank(propValue)) {
			return defaultValue;
		}
		return propValue;
	}

	public GlobalConfig findByKey(String key) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(GlobalConfig.PROP_KEY, key));
			criteria.setMaxResults(1);
			return (GlobalConfig) criteria.uniqueResult();
		}
	}

	public static void setEnabledInventoryPlugin(boolean enabled) {
		getInstance().addProperty("module.inventory.enable", String.valueOf(enabled)); //$NON-NLS-1$
	}

	public static boolean isEnabledInventoryPlugin() {
		return getBooleanProperty("module.inventory.enable", false); //$NON-NLS-1$
	}

	public static Boolean isEnabledRefSystemPlugin() {
		return getBooleanProperty("module.ref_system.enable", false); //$NON-NLS-1$
	}

	public static void setEnabledRefSystemPlugin(boolean value) {
		getInstance().addProperty("module.ref_system.enable", String.valueOf(value)); //$NON-NLS-1$
	}

	public static void setEnabledLabWorksPlugin(boolean enabled) {
		getInstance().addProperty("module.lab_works.enable", String.valueOf(enabled)); //$NON-NLS-1$
	}

	public static boolean isEnabledLabWorksPlugin() {
		return getBooleanProperty("module.lab_works.enable", false); //$NON-NLS-1$
	}

	public static boolean getBooleanProperty(String key, boolean defaultValue) {
		return POSUtil.getBoolean(getInstance().getProperty(key), defaultValue);
	}
}