package com.floreantpos.model.dao;

import java.text.DecimalFormat;
import java.util.List;

import org.hibernate.Session;
import org.hibernate.Transaction;

import com.floreantpos.model.SequenceNumber;

public class SequenceNumberDAO extends BaseSequenceNumberDAO {
	public static final String 	SEQ_LEDGER_ENTRY = "ledger_entry";
	private DecimalFormat fourDigitFormat = new DecimalFormat("0000");

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public SequenceNumberDAO() {
	}
	
	public String getNextLedgerRef(String ref) {
		try (Session session = createNewSession()) {
			Transaction transaction = session.beginTransaction();
			int nextSequenceNumber = getNextSequenceNumber(SEQ_LEDGER_ENTRY, session);
			transaction.commit();
			fourDigitFormat = new DecimalFormat("0000");
			return ref + "/" + fourDigitFormat.format(nextSequenceNumber);
		}
	}

	public int getNextSequenceNumber(String type, Session session) {
		SequenceNumber ref = get(type, session);
		if (ref == null)
			ref = new SequenceNumber(type, 1);

		int refNumber = ref.getNextSequenceNumber();
		ref.setNextSequenceNumber(refNumber + 1);
		session.saveOrUpdate(ref);
		return refNumber;
	}

	public void resetAll(Session session) {
		List<SequenceNumber> refList = findAll(session);
		if (refList == null)
			return;
		for (SequenceNumber ref : refList) {
			ref.setNextSequenceNumber(0);
			session.saveOrUpdate(ref);
		}
	}
}