/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.ProductType;
import com.floreantpos.model.TicketItem;
import com.floreantpos.swing.ListTableModel;

public class LabTestReportModel extends ListTableModel<TicketItem> {
	public LabTestReportModel() {
		super(new String[] { "itemName", "qty", "itemSubtotalAmount", "testCategoryName", "productType" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		TicketItem labTestItem = (TicketItem) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return labTestItem.getNameDisplay();

			case 1:
				return labTestItem.getQuantity();

			case 2:
				return labTestItem.getSubtotalAmount();

			case 3:
				return StringUtils.isNotBlank(labTestItem.getCategoryName()) ? labTestItem.getCategoryName() : "";

			case 4:
				ProductType productType = ProductType.fromString(labTestItem.getProductType());
				if (ProductType.match(labTestItem.getProductType(), ProductType.PATHOLOGY) || ProductType.match(labTestItem.getProductType(), ProductType.SERVICES)) {
					return "";
				}
				if (ProductType.match(labTestItem.getProductType(), ProductType.GOODS)) {
					return "Consumable products";
				}
				return (productType.getDisplayString());

		}
		return null;
	}
}
