/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.MergeTicketDialog;
import com.floreantpos.ui.views.order.StyledTicketSelectionDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.util.Iterator;
import java.util.List;

public class MergeTicketsAction
extends PosAction {
    private DataChangeListener dataChangeListener;

    public MergeTicketsAction() {
        super(Messages.getString("MergeTicketsAction.0"));
    }

    public MergeTicketsAction(DataChangeListener dataChangeListener) {
        super(Messages.getString("MergeTicketsAction.0"));
        this.dataChangeListener = dataChangeListener;
    }

    @Override
    public void execute() {
        try {
            StyledTicketSelectionDialog ticketSelectionDialog = new StyledTicketSelectionDialog();
            ticketSelectionDialog.setMerge(true);
            ticketSelectionDialog.setRequiredNumber(2);
            ticketSelectionDialog.openFullScreen();
            if (ticketSelectionDialog.isCanceled()) {
                return;
            }
            List<Ticket> selectedTickets = ticketSelectionDialog.getSelectedTickets();
            if (selectedTickets.size() <= 0) {
                return;
            }
            MergeTicketDialog dialog = new MergeTicketDialog(selectedTickets, ticketSelectionDialog.getMainTicket());
            dialog.setTitle(Messages.getString("MergeTicketsAction.1"));
            dialog.setSize(PosUIManager.getSize(750, 600));
            dialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                return;
            }
            Ticket mainTicket = dialog.getMainTicket();
            this.logJournal(mainTicket, selectedTickets);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MergeTicketsAction.2") + mainTicket.getTokenNo());
            if (this.dataChangeListener != null) {
                this.dataChangeListener.dataChanged(mainTicket);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void logJournal(Ticket mainTicket, List<Ticket> selectedTickets) {
        StringBuilder sb = new StringBuilder();
        sb.append("Tickets: ");
        Iterator<Ticket> iterator = selectedTickets.iterator();
        while (iterator.hasNext()) {
            Ticket ticket = iterator.next();
            sb.append(ticket.getId());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        String string = sb.toString();
        if (string.length() > 255) {
            string = string.substring(0, 255);
        }
        ActionHistoryDAO.saveHistory(mainTicket, "Merge ticket", string);
    }
}

