/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.ITicketList;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.swing.PosOptionPane;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.payment.AuthorizationCodeDialog;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.ui.views.payment.CardInputListener;
import com.floreantpos.ui.views.payment.CardInputProcessor;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.ui.views.payment.ManualCardEntryDialog;
import com.floreantpos.ui.views.payment.SwipeCardDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.List;
import javax.swing.AbstractAction;
import org.apache.commons.lang.StringUtils;

public class NewBarTabAction
extends AbstractAction
implements CardInputListener {
    public static final String BARTAB_TRANSACTION_ID = "bartab.transaction.id";
    private Component parentComponent;
    private PaymentType selectedPaymentType;
    private OrderType orderType;
    private List<ShopTable> selectedTables;
    private Ticket ticket;
    private double preAuthAmount;

    public NewBarTabAction(OrderType orderType, List selectedTables, Component parentComponent) {
        this.orderType = orderType;
        this.selectedTables = selectedTables;
        this.parentComponent = parentComponent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.ticket = this.createTicket();
        String message = Messages.getString("NewBarTabAction.11");
        int option = POSMessageDialog.showYesNoQuestionDialog(this.parentComponent, message, Messages.getString("NewBarTabAction.4"));
        if (option != 0) {
            this.doEditTicket(this.ticket);
            return;
        }
        this.preAuthAmount = NumberSelectionDialog2.takeDoubleInput("Enter pre auth amount", CardConfig.getBartabLimit());
        if (this.preAuthAmount <= 0.0) {
            return;
        }
        try {
            PaymentGatewayPlugin paymentGateway = CardConfig.getPaymentGateway();
            if (this.selectedPaymentType == null) {
                this.selectedPaymentType = PaymentType.CREDIT_CARD;
            }
            if (!paymentGateway.shouldShowCardInputProcessor()) {
                PosTransaction transaction = this.selectedPaymentType.createTransaction();
                Ticket ticket = this.createTicket();
                if (ticket == null) {
                    return;
                }
                transaction.setTicket(ticket);
                transaction.setAuthorizable(false);
                transaction.setCaptured(false);
                transaction.setCardMerchantGateway(paymentGateway.getProductName());
                transaction.setTenderAmount(this.preAuthAmount);
                transaction.setAmount(this.preAuthAmount);
                paymentGateway.getProcessor().preAuth(transaction);
                this.saveTicket(transaction);
                return;
            }
            CardReader cardReader = CardConfig.getCardReader();
            switch (cardReader) {
                case MANUAL: {
                    ManualCardEntryDialog dialog = new ManualCardEntryDialog(this, PaymentType.CREDIT_CARD);
                    dialog.pack();
                    dialog.open();
                    break;
                }
                default: {
                    SwipeCardDialog swipeCardDialog = new SwipeCardDialog(this, PaymentType.CREDIT_CARD);
                    swipeCardDialog.pack();
                    swipeCardDialog.open();
                    break;
                }
            }
        }
        catch (Exception e3) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e3.getMessage(), e3);
        }
    }

    private Ticket createTicket() {
        Ticket ticket = new Ticket();
        if (this.selectedTables != null && !this.selectedTables.isEmpty()) {
            for (ShopTable shopTable : this.selectedTables) {
                ticket.addTable(shopTable.getTableNumber());
            }
        } else {
            String customerTabName = PosOptionPane.showInputDialog(Messages.getString("NewBarTabAction.12"));
            if (StringUtils.isEmpty((String)customerTabName)) {
                return null;
            }
            ticket.addProperty("CUSTOMER_NAME", customerTabName);
        }
        Application application = Application.getInstance();
        ticket.setPriceIncludesTax(application.isPriceIncludesTax());
        ticket.setOrderType(this.orderType);
        ticket.setTerminal(application.getTerminal());
        ticket.setOwner(Application.getCurrentUser());
        ticket.setShift(ShiftUtil.getCurrentShift());
        Calendar currentTime = Calendar.getInstance();
        ticket.setCreateDate(currentTime.getTime());
        ticket.setCreationHour(currentTime.get(11));
        return ticket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cardInputted(CardInputProcessor inputter, PaymentType paymentType, String cardType) {
        BusyDialog waitDialog = new BusyDialog(Application.getPosWindow());
        try {
            waitDialog.setVisible(true);
            PosTransaction transaction = this.selectedPaymentType.createTransaction();
            if (this.ticket == null) {
                return;
            }
            transaction.setTicket(this.ticket);
            transaction.setAuthorizable(false);
            transaction.setTenderAmount(this.preAuthAmount);
            transaction.setAmount(this.preAuthAmount);
            PaymentGatewayPlugin paymentGateway = CardConfig.getPaymentGateway();
            CardProcessor cardProcessor = paymentGateway.getProcessor();
            if (inputter instanceof SwipeCardDialog) {
                SwipeCardDialog swipeCardDialog = (SwipeCardDialog)inputter;
                String cardString = swipeCardDialog.getCardString();
                if (StringUtils.isEmpty((String)cardString) || cardString.length() < 16) {
                    throw new RuntimeException(Messages.getString("SettleTicketDialog.16"));
                }
                transaction.setCardType(paymentType.getDisplayString());
                transaction.setCardTrack(cardString);
                transaction.setCaptured(false);
                transaction.setCardMerchantGateway(paymentGateway.getProductName());
                transaction.setCardReader(CardReader.SWIPE.name());
                cardProcessor.preAuth(transaction);
                this.saveTicket(transaction);
            } else if (inputter instanceof ManualCardEntryDialog) {
                ManualCardEntryDialog mDialog = (ManualCardEntryDialog)inputter;
                transaction.setCaptured(false);
                transaction.setCardMerchantGateway(paymentGateway.getProductName());
                transaction.setCardReader(CardReader.MANUAL.name());
                transaction.setCardNumber(mDialog.getCardNo());
                transaction.setCardExpMonth(mDialog.getExpMonth());
                transaction.setCardExpYear(mDialog.getExpYear());
                cardProcessor.preAuth(transaction);
                this.saveTicket(transaction);
            } else if (inputter instanceof AuthorizationCodeDialog) {
                PosTransaction selectedTransaction = this.selectedPaymentType.createTransaction();
                selectedTransaction.setTicket(this.ticket);
                AuthorizationCodeDialog authDialog = (AuthorizationCodeDialog)inputter;
                String authorizationCode = authDialog.getAuthorizationCode();
                if (StringUtils.isEmpty((String)authorizationCode)) {
                    throw new PosException(Messages.getString("SettleTicketDialog.17"));
                }
                selectedTransaction.setCardType(this.selectedPaymentType.getDisplayString());
                selectedTransaction.setCaptured(false);
                selectedTransaction.setCardReader(CardReader.EXTERNAL_TERMINAL.name());
                selectedTransaction.setCardAuthCode(authorizationCode);
                this.saveTicket(selectedTransaction);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage(), e);
        }
        finally {
            waitDialog.setVisible(false);
        }
    }

    private void saveTicket(PosTransaction transaction) {
        try {
            PosTransactionService transactionService = PosTransactionService.getInstance();
            Ticket ticket = transaction.getTicket();
            transactionService.bookBartabTicket(ticket, transaction, false);
            ticket.addProperty(BARTAB_TRANSACTION_ID, String.valueOf(transaction.getId()));
            TicketDAO.getInstance().saveOrUpdate(ticket);
            ShopTableDAO.getInstance().occupyTables(ticket);
            POSMessageDialog.showMessage(Messages.getString("NewBarTabAction.5") + ticket.getId());
            if (this.parentComponent instanceof ITicketList) {
                ((ITicketList)((Object)this.parentComponent)).updateTicketList();
            }
            this.doEditTicket(ticket);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    private void doEditTicket(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        if (ticket.getId() != null) {
            ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        }
        OrderView.getInstance().setCurrentTicket(ticket);
        RootView.getInstance().showView("ORDER_VIEW");
    }
}

