/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.apache.commons.lang.StringUtils;

public abstract class PosAction
extends AbstractAction {
    private boolean visible = true;
    protected UserPermission requiredPermission;
    protected ActionEvent event;
    protected User authorizedUser;
    protected DataChangeListener listener;
    protected boolean mandatoryPermission;

    public PosAction() {
    }

    public PosAction(String name) {
        super(name);
    }

    public PosAction(Icon icon) {
        super(null, icon);
    }

    public PosAction(String name, Icon icon) {
        super(name, icon);
    }

    public PosAction(String name, UserPermission requiredPermission) {
        super(name);
        this.requiredPermission = requiredPermission;
    }

    public PosAction(Icon icon, UserPermission requiredPermission) {
        super(null, icon);
        this.requiredPermission = requiredPermission;
    }

    public PosAction(String name, DataChangeListener listener) {
        super(name);
        this.listener = listener;
    }

    public PosAction(DataChangeListener listener) {
        this.listener = listener;
    }

    public void setDataChangedListener(DataChangeListener listener) {
        this.listener = listener;
    }

    public DataChangeListener getDataChangedListener() {
        return this.listener;
    }

    public Object getSelectedObject() {
        if (this.listener == null) {
            return null;
        }
        return this.listener.getSelectedData();
    }

    public UserPermission getRequiredPermission() {
        return this.requiredPermission;
    }

    public void setRequiredPermission(UserPermission requiredPermission) {
        this.requiredPermission = requiredPermission;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.event = e;
            User user = this.getCurrentUser();
            if (this.requiredPermission == null) {
                this.authorizedUser = user;
                this.execute();
                return;
            }
            if (user == null) {
                return;
            }
            this.authorizedUser = user;
            if (!this.hasPermission(user, this.requiredPermission)) {
                return;
            }
            this.execute();
        }
        catch (Exception e2) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
        }
    }

    public boolean hasPermissionToAccessTicket(Ticket ticket) {
        User currentUser = this.getCurrentUser();
        if (ticket != null && ticket.getOwner().getId().equals(currentUser.getId())) {
            return true;
        }
        return this.hasPermission(currentUser, UserPermission.EDIT_OTHER_USERS_TICKETS);
    }

    public boolean hasPermission(User user, UserPermission requiredPermission) {
        if (this.isMandatoryPermission() || !user.hasPermission(requiredPermission)) {
            String password = PasswordEntryDialog.show(POSUtil.getFocusedWindow(), Messages.getString("PosAction.0"));
            if (StringUtils.isEmpty((String)password)) {
                return false;
            }
            User newUser = UserDAO.getInstance().findUserBySecretKey(password);
            if (newUser == null) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PosAction.1"));
                return false;
            }
            if (!newUser.hasPermissionInAnyRole(requiredPermission)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PosAction.2"));
                return false;
            }
            this.authorizedUser = newUser;
            return true;
        }
        return true;
    }

    public abstract void execute() throws Exception;

    public ActionEvent getActionEvent() {
        return this.event;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public User getAuthorizedUser() {
        return this.authorizedUser;
    }

    public boolean isMandatoryPermission() {
        return this.mandatoryPermission;
    }

    public void setMandatoryPermission(boolean mandatoryPermission) {
        this.mandatoryPermission = mandatoryPermission;
    }

    protected User getCurrentUser() {
        return Application.getCurrentUser();
    }
}

