/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.DefaultCustomerListView;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.EmailSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;

public class ReceiptEmailSendAction
extends PosAction {
    private PosTransaction transaction;

    public ReceiptEmailSendAction(PosTransaction posTransaction) {
        super(Messages.getString("ReceiptEmailSendAction.0"));
        this.transaction = posTransaction;
    }

    @Override
    public void execute() {
        try {
            if (this.transaction == null) {
                return;
            }
            Customer customer = this.getCustomer(this.transaction.getTicket());
            if (customer == null) {
                return;
            }
            String title = Messages.getString("ReceiptEmailSendAction.1");
            EmailSelectionDialog dialog = new EmailSelectionDialog(title, customer.getEmail(), customer.getEmail2()){

                @Override
                public boolean doSendEmail(String email) {
                    try {
                        MailService.sendTransaction(email, ReceiptEmailSendAction.this.transaction);
                        String message = String.format(Messages.getString("ReceiptEmailSendAction.2"), email);
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), message);
                        return true;
                    }
                    catch (Exception e) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
                        return false;
                    }
                }
            };
            dialog.pack();
            dialog.open();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private Customer getCustomer(Ticket ticket) throws Exception {
        Customer customer = null;
        String customerId = ticket.getCustomerId();
        if (customerId == null) {
            String message = Messages.getString("ReceiptEmailSendAction.3");
            String title = Messages.getString("ReceiptEmailSendAction.4");
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), message, title);
            if (option != 0) {
                return null;
            }
            CustomerSelectorDialog dialog = new CustomerSelectorDialog(new DefaultCustomerListView());
            dialog.setCreateNewTicket(false);
            dialog.updateView(true);
            dialog.openUndecoratedFullScreen();
            if (dialog.isCanceled()) {
                return null;
            }
            customer = dialog.getSelectedCustomer();
            if (customer != null) {
                ticket.setCustomer(customer);
                TicketDAO.getInstance().saveOrUpdate(ticket);
            }
        } else {
            customer = CustomerDAO.getInstance().get(customerId);
        }
        return customer;
    }
}

