/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.services.TicketService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;

public class SendToKitchenAction
extends PosAction {
    public SendToKitchenAction() {
        super(Messages.getString("SendToKitchenAction.0"));
    }

    public SendToKitchenAction(DataChangeListener listener) {
        super(Messages.getString("SendToKitchenAction.1"), listener);
    }

    @Override
    public void execute() {
        try {
            Object selectedObject = this.getSelectedObject();
            if (selectedObject == null) {
                return;
            }
            Ticket ticket = null;
            ticket = selectedObject instanceof Ticket ? (Ticket)selectedObject : TicketService.getTicket((String)selectedObject);
            if (!this.isPrintableToKitchen(ticket)) {
                return;
            }
            TicketDAO.getInstance().loadFullTicket(ticket);
            if (ticket.getTicketItems() == null || ticket.getTicketItems().isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SendToKitchenAction.4"));
                return;
            }
            this.doSendNewItemsToKitchen(ticket);
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public boolean isPrintableToKitchen(Ticket ticket) {
        if (!ticket.getOrderType().isShouldPrintToKitchen().booleanValue()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SendToKitchenAction.2"));
            return false;
        }
        if (ticket.isVoided().booleanValue()) {
            POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
            return false;
        }
        PosPrinters printers = DataProvider.get().getPrinters();
        if (printers.getKitchenPrinters().size() == 0 && printers.getStickerPrinters().size() == 0 && !printers.isPrintToKds()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SendToKitchenAction.3"));
            return false;
        }
        return true;
    }

    public void doSendNewItemsToKitchen(Ticket ticket) {
        if (ticket.getOrderType().isShouldPrintToKitchen().booleanValue()) {
            if (ticket.needsKitchenPrint()) {
                ReceiptPrintService.printToKitchen(ticket, true);
                ActionHistoryDAO.saveHistory(ticket, "Sent to kitchen", "Check#: " + ticket.getId());
                POSMessageDialog.showMessage(Messages.getString("TicketView.32"));
            } else {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TicketView.333"));
            }
        }
    }
}

