/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.actions.PosAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.customer.clubmember.ClubMemberSelectionListener;
import com.floreantpos.customer.clubmember.ClubMemberSelectionPane;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.model.Customer;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.TicketAlreadyExistsException;

public class ShowCustomerSelectionHomeViewAction
extends PosAction {
    private RootView rootView;
    private OrderType orderType;

    public ShowCustomerSelectionHomeViewAction(RootView rootView, OrderType orderType) {
        this.rootView = rootView;
        this.orderType = orderType;
    }

    @Override
    public void execute() throws Exception {
        if (this.rootView.hasView("MEMBER_SELECTION_VIEW")) {
            this.rootView.showView("MEMBER_SELECTION_VIEW");
        } else {
            ClubMemberSelectionListener memberSelectionListener = new ClubMemberSelectionListener(){

                @Override
                public void memberSelectionCanceled() {
                }

                @Override
                public void clubMemberSelected(Customer clubMember) {
                    String defaultViewName = TerminalConfig.getDefaultView();
                    OrderType orderType = DataProvider.get().getOrderType(defaultViewName);
                    try {
                        OrderServiceFactory.getOrderService().createNewTicket(orderType, null, clubMember);
                    }
                    catch (TicketAlreadyExistsException ticketAlreadyExistsException) {
                        // empty catch block
                    }
                }
            };
            ClubMemberSelectionPane cMSP = new ClubMemberSelectionPane(memberSelectionListener);
            cMSP.setOrderType(this.orderType);
            this.rootView.setAndShowHomeScreen(cMSP);
        }
    }
}

