/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.PrinterIsNotConfiguredException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.ui.dialog.CashReconciliationDialog;
import com.floreantpos.ui.dialog.MultiCurrencyAmountSelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;

public class StaffBankStartStopAction
extends PosAction {
    public static final double FORCE_CLOSE_RECONCILE_AMOUNT = 0.0;
    private User assignToUser;

    public StaffBankStartStopAction(User assignedToUser) {
        super("Start Staff Bank");
        this.assignToUser = assignedToUser;
        this.updateActionText();
    }

    public void updateActionText() {
    }

    @Override
    public void execute() {
        try {
            if (this.assignToUser.isStaffBankStarted().booleanValue()) {
                int option = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("StaffBankStartStopAction.0"), Messages.getString("CONFIRM"));
                if (option != 0) {
                    return;
                }
                this.performCloseStaffBank();
            } else {
                this.performStartStaffBank();
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public void performStartStaffBank() throws Exception {
        if (!this.assignToUser.isClockedIn().booleanValue()) {
            POSMessageDialog.showError(Messages.getString("StaffBankStartStopAction.2"));
            return;
        }
        UserDAO.getInstance().startStaffBank(this.assignToUser);
        Application.getInstance().refreshCurrentUser();
        this.updateActionText();
    }

    public void performCloseStaffBank() throws Exception {
        try {
            CashDrawer report = this.assignToUser.getActiveDrawerPullReport();
            CashDrawerReportService reportService = new CashDrawerReportService(report);
            reportService.populateReport();
            Double reconcileAmount = 0.0;
            Application application = Application.getInstance();
            if (application.getStore().isUseDetailedReconciliation().booleanValue()) {
                CashReconciliationDialog dialog = new CashReconciliationDialog(report);
                dialog.pack();
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                reconcileAmount = dialog.getTotalReconcilieAmount();
            } else if (application.getTerminal().isEnableMultiCurrency().booleanValue()) {
                MultiCurrencyAmountSelectionDialog multiCurrencyDialog = new MultiCurrencyAmountSelectionDialog(report, report.getDrawerAccountable(), CurrencyUtil.getAllCurrency());
                multiCurrencyDialog.setTitle(Messages.getString("StaffBankStartStopAction.3"));
                multiCurrencyDialog.setCaption(Messages.getString("StaffBankStartStopAction.4"));
                multiCurrencyDialog.setReconcile(true);
                multiCurrencyDialog.pack();
                multiCurrencyDialog.open();
                if (multiCurrencyDialog.isCanceled()) {
                    return;
                }
                reconcileAmount = multiCurrencyDialog.getTotalAmount();
            } else {
                reconcileAmount = this.getReconcileAmount(report);
                if (reconcileAmount.isNaN()) {
                    return;
                }
            }
            report.setCashToDeposit(reconcileAmount);
            TerminalDAO dao = new TerminalDAO();
            dao.resetStaffBank(this.assignToUser, report);
            User currentUser = Application.getCurrentUser();
            if (currentUser != null && currentUser.getId().equals(report.getAssignedUser().getId())) {
                Application.getInstance().setCurrentUser(UserDAO.getInstance().get(currentUser.getId()));
            }
            this.updateActionText();
            PosPrintService.printDrawerPullReport(report);
        }
        catch (PrinterIsNotConfiguredException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("StaffBankStartStopAction.5") + e.getMessage());
        }
        catch (Exception e) {
            throw e;
        }
    }

    private Double getReconcileAmount(CashDrawer report) {
        Double reconcileAmount = NumberSelectionDialog2.takeDoubleInput(Messages.getString("StaffBankStartStopAction.6"), Messages.getString("StaffBankStartStopAction.7"), this.assignToUser.isBlindAccountableAmount() != false ? 0.0 : report.getDrawerAccountable());
        if (Double.isNaN(reconcileAmount)) {
            return Double.NaN;
        }
        if (reconcileAmount < report.getDrawerAccountable()) {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("StaffBankStartStopAction.8"), Messages.getString("CONFIRM")) == 0) {
                return reconcileAmount;
            }
            return this.getReconcileAmount(report);
        }
        return reconcileAmount;
    }
}

