/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.ui.views.payment.PaymentView;
import com.floreantpos.ui.views.payment.SettleTicketDialog;

public class TaxExemptAction
extends PosAction {
    private Ticket ticket;
    private SettleTicketDialog settleTicketDialog;
    private PaymentView paymentView;

    public TaxExemptAction(Ticket ticket, SettleTicketDialog settleTicketDialog, PaymentView paymentView) {
        this.ticket = ticket;
        this.settleTicketDialog = settleTicketDialog;
        this.paymentView = paymentView;
        this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
        this.setMandatoryPermission(Boolean.TRUE);
    }

    @Override
    public void execute() throws Exception {
        if (this.ticket.isTaxExempt().booleanValue()) {
            this.ticket.setTaxExempt(Boolean.FALSE);
        } else {
            this.ticket.setTaxExempt(Boolean.TRUE);
        }
        this.ticket.calculatePrice();
        this.paymentView.updateView();
        this.settleTicketDialog.updateView();
        Boolean isTaxExempt = this.ticket.isTaxExempt();
        String taxAmount = Messages.getString("SettleTicketDialog.14") + "#:" + this.ticket.getTaxAmount();
        String ticketId = POSConstants.TICKET_ID + "#:" + this.ticket.getId();
        String created = POSConstants.CREATED + "#:" + String.valueOf(this.ticket.getCreateDate());
        String ticketIdOrCreated = this.ticket.getId() == null ? created : ticketId;
        String description = taxAmount + "," + ticketIdOrCreated;
        String exemptOrUnexempt = isTaxExempt != false ? "Tax unexempt" : "Tax exempt";
        ActionHistoryDAO.getInstance();
        ActionHistoryDAO.saveHistory(exemptOrUnexempt, description);
    }
}

