/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.TransferTicketDialog;
import com.floreantpos.ui.views.order.StyledTicketSelectionDialog;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TransferTicketItemsAction
extends PosAction {
    public TransferTicketItemsAction() {
        super(Messages.getString("TransferTicketItemsAction.0"));
    }

    @Override
    public void execute() {
        try {
            StyledTicketSelectionDialog ticketSelectionDialog = new StyledTicketSelectionDialog();
            ticketSelectionDialog.setCaption(Messages.getString("TransferTicketItemsAction.1"));
            ticketSelectionDialog.setRequiredNumber(2);
            ticketSelectionDialog.openFullScreen();
            if (ticketSelectionDialog.isCanceled()) {
                return;
            }
            List<Ticket> selectedTickets = ticketSelectionDialog.getSelectedTickets();
            if (selectedTickets.size() <= 0) {
                return;
            }
            ArrayList<Ticket> loadedTickets = new ArrayList<Ticket>();
            for (Ticket ticket : selectedTickets) {
                loadedTickets.add(TicketDAO.getInstance().loadFullTicket(ticket.getId()));
            }
            TransferTicketDialog dialog = new TransferTicketDialog(loadedTickets);
            dialog.setTitle(Messages.getString("TransferTicketItemsAction.2"));
            dialog.openFullScreen();
            if (dialog.isCanceled()) {
                return;
            }
            this.logJournal(selectedTickets);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TransferTicketItemsAction.4"));
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void logJournal(List<Ticket> selectedTickets) {
        StringBuilder sb = new StringBuilder();
        sb.append("Items transfered among: ");
        Iterator<Ticket> iterator = selectedTickets.iterator();
        while (iterator.hasNext()) {
            Ticket ticket = iterator.next();
            sb.append(ticket.getId());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        String string = sb.toString();
        if (string.length() > 255) {
            string = string.substring(0, 255);
        }
        ActionHistoryDAO.saveHistory("Transfer items", string);
    }
}

