/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.foretees.salesforce.sync.PaymentSyncable;
import com.foretees.salesforce.sync.SyncDialog;
import com.foretees.salesforce.sync.SyncErrorDialog;
import java.util.List;
import org.hibernate.StaleStateException;

public class UploadPaymentSyncableAction
extends PosAction {
    private List<Object> objects;
    private Boolean isUploadSeperately;
    private int numItemsToUpload;

    public UploadPaymentSyncableAction(List<Object> objects) {
        this(objects, false);
    }

    public UploadPaymentSyncableAction(List<Object> objects, boolean isUploadSeperately) {
        super(Messages.getString("UploadPaymentSyncableAction.0"));
        this.objects = objects;
        this.isUploadSeperately = isUploadSeperately;
    }

    public UploadPaymentSyncableAction(List<Object> objects, int numItemsToUpload) {
        super(Messages.getString("UploadPaymentSyncableAction.0"));
        this.objects = objects;
        this.isUploadSeperately = null;
        this.numItemsToUpload = numItemsToUpload;
    }

    @Override
    public void execute() {
        SyncDialog dialog = null;
        try {
            PaymentSyncable paymentSyncable = new PaymentSyncable(this.objects, this.isUploadSeperately, this.numItemsToUpload);
            dialog = new SyncDialog(paymentSyncable);
            paymentSyncable.setSyncView(dialog);
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            if (!paymentSyncable.hasSyncError) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("UploadPaymentSyncableAction.1"));
                return;
            }
            SyncErrorDialog errorDialog = new SyncErrorDialog(dialog);
            errorDialog.setErrorMessage(Messages.getString("UploadPaymentSyncableAction.2"));
            errorDialog.setErrorItems(paymentSyncable.getErrorItems());
            errorDialog.open();
        }
        catch (StaleStateException x) {
            POSMessageDialog.showError(dialog, x.getMessage());
            return;
        }
        catch (Exception e) {
            POSMessageDialog.showError(dialog, POSConstants.ERROR_MESSAGE, e);
        }
    }
}

