/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.report.GiftCardTransactionReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class GiftCardTransactionReportAction
extends AbstractAction {
    public GiftCardTransactionReportAction() {
        super(Messages.getString("GiftCardTransactionReportAction.0"));
    }

    public GiftCardTransactionReportAction(String name) {
        super(name);
    }

    public GiftCardTransactionReportAction(String name, Icon icon) {
        super(name, icon);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane tabbedPane = backOfficeWindow.getTabbedPane();
            GiftCardTransactionReportView reportView = null;
            String tabhead = Messages.getString("GiftCardTransactionReportAction.0");
            int index = tabbedPane.indexOfTab(tabhead);
            if (index == -1) {
                reportView = new GiftCardTransactionReportView();
                tabbedPane.addTab(tabhead, reportView);
            } else {
                reportView = (GiftCardTransactionReportView)tabbedPane.getComponentAt(index);
            }
            tabbedPane.setSelectedComponent(reportView);
        }
        catch (Exception e) {
            POSMessageDialog.showError(backOfficeWindow, e.getMessage(), e);
        }
    }
}

