/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.PizzaExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class PizzaItemExplorerAction
extends AbstractAction {
    public PizzaItemExplorerAction() {
        super(Messages.getString("PizzaItemExplorerAction.0"));
    }

    public PizzaItemExplorerAction(String name) {
        super(name);
    }

    public PizzaItemExplorerAction(String name, Icon icon) {
        super(name, icon);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane tabbedPane = backOfficeWindow.getTabbedPane();
            PizzaExplorer explorer = null;
            int index = tabbedPane.indexOfTab(Messages.getString("PizzaItemExplorerAction.0"));
            if (index == -1) {
                explorer = new PizzaExplorer();
                tabbedPane.addTab(Messages.getString("PizzaItemExplorerAction.0"), (Component)explorer);
            } else {
                explorer = (PizzaExplorer)tabbedPane.getComponentAt(index);
            }
            tabbedPane.setSelectedComponent((Component)explorer);
        }
        catch (Exception e) {
            POSMessageDialog.showError(backOfficeWindow, e.getMessage(), e);
        }
    }
}

