/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.DateChoserDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class AttendanceHistoryExplorer
extends TransparentPanel {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, YYYY hh:mm a");
    private JButton btnGo = new JButton(POSConstants.GO);
    private JButton btnAdd = new JButton(Messages.getString("AttendanceHistoryExplorer.0"));
    private JButton btnEdit = new JButton(Messages.getString("AttendanceHistoryExplorer.1"));
    private JXTable table;
    private AttendenceHistoryTableModel attendenceHistoryTableModel;
    private JComboBox cbUser;
    private OverflowCombobox cbUserRole;
    private JPanel contentPanel;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;

    public AttendanceHistoryExplorer() {
        super(new BorderLayout());
        JPanel topSearchPanel = new JPanel((LayoutManager)new MigLayout());
        this.cbUser = new JComboBox();
        List<User> users = UserDAO.getInstance().findAllActive();
        Vector<Object> userList = new Vector<Object>();
        userList.add(POSConstants.ALL);
        userList.addAll(users);
        this.cbUser.setModel(new DefaultComboBoxModel(userList));
        this.cbUserRole = new OverflowCombobox();
        List<UserType> userRoles = UserTypeDAO.getInstance().findAll();
        Vector<Object> userRoleList = new Vector<Object>();
        userRoleList.add(POSConstants.ALL);
        userRoleList.addAll(userRoles);
        this.cbUserRole.setModel(new DefaultComboBoxModel(userRoleList));
        this.fromDatePicker = UiUtil.getCurrentMonthStart();
        this.fromDatePicker.setFormats(new String[]{"MMM dd, yyyy"});
        topSearchPanel.add((Component)new JLabel(POSConstants.START_DATE), "grow");
        topSearchPanel.add((Component)this.fromDatePicker);
        this.toDatePicker = UiUtil.getCurrentMonthEnd();
        topSearchPanel.add((Component)new JLabel(POSConstants.END_DATE), "grow");
        this.toDatePicker.setFormats(new String[]{"MMM dd, yyyy"});
        topSearchPanel.add((Component)this.toDatePicker);
        topSearchPanel.add(new JLabel(POSConstants.USER + ":"));
        topSearchPanel.add(this.cbUser);
        topSearchPanel.add(new JLabel(Messages.getString("ROLE") + ":"));
        topSearchPanel.add((Component)this.cbUserRole, "width 120!");
        topSearchPanel.add((Component)this.btnGo, "skip 1, al right");
        this.add((Component)topSearchPanel, "North");
        this.contentPanel = new JPanel(new BorderLayout());
        this.add(this.contentPanel);
        this.createBottomActionPanel();
        this.table = new JXTable();
        this.attendenceHistoryTableModel = new AttendenceHistoryTableModel();
        this.table.setModel((TableModel)this.attendenceHistoryTableModel);
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        this.contentPanel.add((Component)scrollPane, "Center");
        this.resizeColumnWidth((JTable)this.table);
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    private void createBottomActionPanel() {
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        bottomPanel.add(this.btnAdd);
        bottomPanel.add(this.btnEdit);
        this.add((Component)bottomPanel, "South");
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AttendanceHistoryExplorer.this.doSearch();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(AttendanceHistoryExplorer.this, POSConstants.ERROR_MESSAGE, e1);
                }
            }
        });
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = AttendanceHistoryExplorer.this.table.getSelectedRow();
                if (selectedRow < 0) {
                    POSMessageDialog.showError(AttendanceHistoryExplorer.this, Messages.getString("AttendanceHistoryExplorer.4"));
                    return;
                }
                int row = AttendanceHistoryExplorer.this.table.convertRowIndexToModel(selectedRow);
                AttendenceHistoryTableModel model = (AttendenceHistoryTableModel)AttendanceHistoryExplorer.this.table.getModel();
                AttendenceHistory history = (AttendenceHistory)model.getRowData(row);
                DateChoserDialog dialog = new DateChoserDialog(history, Messages.getString("AttendanceHistoryExplorer.5"));
                dialog.pack();
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                if (dialog.getAttendenceHistory() != null) {
                    history = dialog.getAttendenceHistory();
                }
                AttendenceHistoryDAO dao = new AttendenceHistoryDAO();
                dao.saveOrUpdate(history);
                model.updateItem(selectedRow);
            }
        });
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChoserDialog dialog = new DateChoserDialog(Messages.getString("AttendanceHistoryExplorer.6"));
                dialog.pack();
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                AttendenceHistory history = null;
                if (dialog.getAttendenceHistory() != null) {
                    history = dialog.getAttendenceHistory();
                }
                AttendenceHistoryDAO dao = new AttendenceHistoryDAO();
                dao.saveOrUpdate(history);
                AttendenceHistoryTableModel model = (AttendenceHistoryTableModel)AttendanceHistoryExplorer.this.table.getModel();
                model.addItem(history);
            }
        });
    }

    private void doSearch() {
        try {
            Date fromDate = DateUtil.startOfDay(this.fromDatePicker.getDate());
            Date toDate = DateUtil.endOfDay(this.toDatePicker.getDate());
            if (fromDate.after(toDate)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
                return;
            }
            User user = null;
            if (!this.cbUser.getSelectedItem().equals(POSConstants.ALL)) {
                user = (User)this.cbUser.getSelectedItem();
            }
            UserType userType = null;
            if (!this.cbUserRole.getSelectedItem().equals(POSConstants.ALL)) {
                userType = (UserType)this.cbUserRole.getSelectedItem();
            }
            List<AttendenceHistory> historyList = AttendenceHistoryDAO.getInstance().findHistory(fromDate, toDate, user, userType);
            this.attendenceHistoryTableModel.setRows(historyList);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(5);
        columnWidth.add(20);
        columnWidth.add(500);
        columnWidth.add(70);
        columnWidth.add(70);
        columnWidth.add(40);
        columnWidth.add(40);
        columnWidth.add(40);
        columnWidth.add(40);
        return columnWidth;
    }

    class AttendenceHistoryTableModel
    extends ListTableModel {
        String[] columnNames = new String[]{Messages.getString("AttendanceHistoryExplorer.14"), Messages.getString("AttendanceHistoryExplorer.7"), Messages.getString("AttendanceHistoryExplorer.8"), Messages.getString("ROLE"), Messages.getString("AttendanceHistoryExplorer.9"), Messages.getString("AttendanceHistoryExplorer.10"), Messages.getString("AttendanceHistoryExplorer.11"), Messages.getString("AttendanceHistoryExplorer.12"), Messages.getString("AttendanceHistoryExplorer.13")};

        public AttendenceHistoryTableModel() {
            this.setColumnNames(this.columnNames);
        }

        AttendenceHistoryTableModel(List<AttendenceHistory> list) {
            this.setRows(list);
            this.setColumnNames(this.columnNames);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            AttendenceHistory history = (AttendenceHistory)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return rowIndex + 1;
                }
                case 1: {
                    return history.getUser().getId();
                }
                case 2: {
                    return history.getUser().getFirstName() + " " + history.getUser().getLastName();
                }
                case 3: {
                    String userTypeId = history.getUser().getUserTypeId();
                    if (userTypeId != null) {
                        UserType userType = UserTypeDAO.getInstance().get(userTypeId);
                        return userType.getName();
                    }
                    return userTypeId;
                }
                case 4: {
                    Date date = history.getClockInTime();
                    if (date != null) {
                        return AttendanceHistoryExplorer.this.dateFormat.format(date);
                    }
                    return "";
                }
                case 5: {
                    Date date2 = history.getClockOutTime();
                    if (date2 != null) {
                        return AttendanceHistoryExplorer.this.dateFormat.format(date2);
                    }
                    return "";
                }
                case 6: {
                    return history.isClockedOut() == false;
                }
                case 7: {
                    if (history.getShift() == null) {
                        return "";
                    }
                    return history.getShift().getId();
                }
                case 8: {
                    return history.getTerminal().getId();
                }
            }
            return null;
        }
    }
}

