/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Currency;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.CurrencyForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;
import org.jdesktop.swingx.JXTable;

public class CurrencyExplorer
extends TransparentPanel
implements RefreshableView {
    private JXTable table;
    private BeanTableModel<Currency> tableModel;

    public CurrencyExplorer() {
        this.initUI();
        this.initData();
    }

    private void initUI() {
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new BeanTableModel(Currency.class);
        this.tableModel.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.tableModel.addColumn(Messages.getString("CurrencyExplorer.0"), "code");
        this.tableModel.addColumn(Messages.getString("CurrencyExplorer.2"), "symbol");
        this.tableModel.addColumn(Messages.getString("CurrencyExplorer.4"), "exchangeRate");
        this.tableModel.addColumn(Messages.getString("CurrencyExplorer.6"), "main");
        this.tableModel.addColumn(Messages.getString("CurrencyExplorer.8"), "tolerance");
        this.table = new JXTable(this.tableModel);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.table.setRowHeight(PosUIManager.getSize(30));
        JButton addButton = new JButton(POSConstants.ADD);
        addButton.addActionListener(e -> this.doAddCurrency());
        JButton editButton = new JButton(POSConstants.EDIT);
        editButton.addActionListener(e -> this.doEditCurrency());
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.addActionListener(e -> this.doDeleteCurrency());
        TransparentPanel panel = new TransparentPanel();
        panel.add(addButton);
        panel.add(editButton);
        panel.add(deleteButton);
        this.add((Component)this.refreshPanel(), "North");
        this.add((Component)new JScrollPane((Component)this.table), "Center");
        this.add((Component)panel, "South");
    }

    private JPanel refreshPanel() {
        JPanel mainPanel = new JPanel((LayoutManager)new MigLayout());
        mainPanel.setBorder(BorderFactory.createTitledBorder(POSConstants.REFRESH));
        JButton btnRefres = new JButton(POSConstants.REFRESH);
        btnRefres.addActionListener(e -> this.initData());
        mainPanel.add(btnRefres);
        return mainPanel;
    }

    protected BeanTableModel<Currency> getModel() {
        return this.tableModel;
    }

    private void initData() {
        try {
            List<Currency> listOfCurrencies = this.tableModel.getRows();
            if (listOfCurrencies != null && listOfCurrencies.size() != 0) {
                listOfCurrencies.clear();
            }
            this.tableModel.addRows(CurrencyDAO.getInstance().findAll());
            this.table.revalidate();
            this.table.repaint();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
    }

    private void doAddCurrency() {
        try {
            CurrencyForm editor = new CurrencyForm();
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.tableModel.addRow((Currency)editor.getBean());
            this.initData();
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doDeleteCurrency() {
        try {
            Currency selectedCurrency = this.getSelectedCurrency();
            if (selectedCurrency == null) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CurrencyExplorer.3"));
                return;
            }
            if (ConfirmDeleteDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                CurrencyDAO.getInstance().delete(selectedCurrency);
                this.tableModel.removeRow(selectedCurrency);
            }
        }
        catch (PosException x) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), x.getMessage());
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception x) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doEditCurrency() {
        try {
            Currency selectedCurrency = this.getSelectedCurrency();
            if (selectedCurrency == null) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CurrencyExplorer.1"));
                return;
            }
            selectedCurrency = CurrencyDAO.getInstance().get(selectedCurrency.getId());
            if (selectedCurrency.isDeleted().booleanValue()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CuurencyIsDeleted"));
                this.initData();
                return;
            }
            CurrencyForm currencyForm = new CurrencyForm(selectedCurrency);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)currencyForm);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.initData();
        }
        catch (Throwable x) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    @Override
    public void refresh() {
        this.initData();
    }

    private Currency getSelectedCurrency() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return null;
        }
        index = this.table.convertRowIndexToModel(index);
        return this.tableModel.getRow(index);
    }
}

