/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.Department;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;

public class DepartmentEntryForm
extends BeanEditor<Department> {
    DefaultMutableTreeNode path;
    private Department dept;
    private FixedLengthTextField tfDeptName;
    private FixedLengthTextField tfAddress;
    private FixedLengthTextField tfDesc;
    private CheckBoxList saleAreaList = new CheckBoxList();
    private CheckBoxList outletList = new CheckBoxList();

    public DepartmentEntryForm(Department dept) {
        this.dept = dept;
        DepartmentDAO.getInstance().initialize(dept);
        this.setLayout(new BorderLayout());
        this.createUI();
        this.setBean(dept);
    }

    public DepartmentEntryForm() {
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    private void createUI() {
        JPanel itemInfoPanel = new JPanel();
        this.add((Component)itemInfoPanel, "Center");
        itemInfoPanel.setLayout((LayoutManager)new MigLayout("", "[][grow][]", ""));
        JLabel lblDeptName = new JLabel(Messages.getString("NAME"));
        itemInfoPanel.add((Component)lblDeptName, "cell 0 0,alignx trailing");
        this.tfDeptName = new FixedLengthTextField(20, 60);
        itemInfoPanel.add((Component)this.tfDeptName, "cell 1 0,growx");
        JLabel lblAddress = new JLabel(Messages.getString("DepartmentEntryForm.6"));
        itemInfoPanel.add((Component)lblAddress, "cell 0 1,alignx trailing");
        this.tfAddress = new FixedLengthTextField(20, 220);
        itemInfoPanel.add((Component)this.tfAddress, "cell 1 1,growx");
        JLabel lblDesc = new JLabel(Messages.getString("DepartmentEntryForm.9"));
        itemInfoPanel.add((Component)lblDesc, "cell 0 2,alignx trailing");
        this.tfDesc = new FixedLengthTextField(20, 255);
        itemInfoPanel.add((Component)this.tfDesc, "cell 1 2,growx");
        OutletDAO outletDAO = new OutletDAO();
        List<Outlet> outletTypes = outletDAO.findAll();
        if (outletTypes == null) {
            outletTypes = new ArrayList<Outlet>();
        }
        this.outletList.setModel(outletTypes);
        TitledBorder titleOutlet = new TitledBorder(Messages.getString("DepartmentEntryForm.0"));
        JScrollPane outletPane = new JScrollPane(this.outletList);
        outletPane.setBorder(titleOutlet);
        itemInfoPanel.add((Component)outletPane, "cell 0 3,growx,span 2,center");
        List<SalesArea> saleAreaTypes = SalesAreaDAO.getInstance().findAll();
        if (saleAreaTypes == null) {
            return;
        }
        this.saleAreaList.setModel(saleAreaTypes);
        this.saleAreaList.setEnabled(false);
        TitledBorder titelSalesArea = new TitledBorder(Messages.getString("DepartmentEntryForm.2"));
        JScrollPane salesAreaPane = new JScrollPane(this.saleAreaList);
        salesAreaPane.setBorder(titelSalesArea);
        itemInfoPanel.add((Component)salesAreaPane, "cell 0 4,growx,span 2,center");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Department deptItem = (Department)this.getBean();
            DepartmentDAO deptDAO = new DepartmentDAO();
            deptDAO.saveOrUpdate(deptItem);
            return true;
        }
        catch (PosException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
        }
        return false;
    }

    @Override
    public void updateView() {
        Department dept = (Department)this.getBean();
        if (dept == null) {
            return;
        }
        this.tfDeptName.setText(dept.getName());
        this.tfAddress.setText(dept.getAddress());
        this.tfDesc.setText(dept.getDescription());
        this.outletList.selectItems(dept.getOutlets());
        this.saleAreaList.selectItems(SalesAreaDAO.getInstance().findSalesAreaByDept(dept));
    }

    @Override
    public boolean updateModel() {
        String deptName = this.tfDeptName.getText();
        Department dept = (Department)this.getBean();
        if (dept == null) {
            return false;
        }
        GenericDAO.getInstance().checkIdOrNameExists(dept.getId(), deptName, Department.class);
        dept.setName(deptName);
        dept.setAddress(this.tfAddress.getText());
        dept.setDescription(this.tfDesc.getText());
        dept.setOutlets(this.outletList.getCheckedValues());
        return true;
    }

    @Override
    public String getDisplayText() {
        if (this.dept.getId() == null) {
            return Messages.getString("DepartmentEntryForm.5");
        }
        return Messages.getString("DepartmentEntryForm.7");
    }
}

