/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.hibernate.Session;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class DrawerPullReportExplorer
extends TransparentPanel {
    private JXDatePicker fromDatePicker = UiUtil.getCurrentMonthStart();
    private JXDatePicker toDatePicker = UiUtil.getCurrentMonthEnd();
    private JButton btnGo = new JButton(POSConstants.GO);
    private JButton btnEditActualAmount = new JButton(POSConstants.EDIT_ACTUAL_AMOUNT);
    private JButton btnPrint = new JButton(Messages.getString("Print"));
    private TableColumnModelExt columnModel;
    private PosTable table;
    private JButton btnBack;
    private JButton btnForward;
    private JLabel lblNumberOfItem;
    private DrawerPullExplorerTableModel tableModel;

    public DrawerPullReportExplorer() {
        super(new BorderLayout());
        this.initUI();
        this.showCashDrawerReport();
    }

    private void initUI() {
        this.tableModel = new DrawerPullExplorerTableModel();
        this.tableModel.addColumn(POSConstants.TIME, CashDrawer.PROP_REPORT_TIME, 11, BeanTableModel.DataType.DATE);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.2"), CashDrawer.PROP_TICKET_COUNT);
        this.tableModel.addColumn(POSConstants.DRAWER_PULL_AMOUNT, CashDrawer.PROP_DRAWER_ACCOUNTABLE, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.3"), CashDrawer.PROP_ASSIGNED_USER_ID);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.4"), CashDrawer.PROP_TERMINAL_ID);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.5"), CashDrawer.PROP_BEGIN_CASH, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.6"), CashDrawer.PROP_NET_SALES, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.7"), CashDrawer.PROP_SALES_TAX, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.8"), CashDrawer.PROP_CASH_TAX, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.9"), CashDrawer.PROP_TOTAL_REVENUE, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.10"), CashDrawer.PROP_GROSS_RECEIPTS);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.11"), CashDrawer.PROP_GIFT_CERT_RETURN_COUNT);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.12"), CashDrawer.PROP_GIFT_CERT_RETURN_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.13"), CashDrawer.PROP_GIFT_CERT_CHANGE_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.14"), CashDrawer.PROP_CASH_RECEIPT_COUNT);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.15"), CashDrawer.PROP_CASH_RECEIPT_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.16"), CashDrawer.PROP_CASH_RECEIPT_COUNT);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.17"), CashDrawer.PROP_CREDIT_CARD_RECEIPT_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.18"), CashDrawer.PROP_DEBIT_CARD_RECEIPT_COUNT);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.19"), CashDrawer.PROP_DEBIT_CARD_RECEIPT_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.20"), CashDrawer.PROP_REFUND_RECEIPT_COUNT);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.21"), CashDrawer.PROP_REFUND_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.22"), CashDrawer.PROP_RECEIPT_DIFFERENTIAL, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.23"), CashDrawer.PROP_CASH_BACK, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.24"), CashDrawer.PROP_CASH_TIPS, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.25"), CashDrawer.PROP_CHARGED_TIPS, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.26"), CashDrawer.PROP_TIPS_PAID, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.27"), CashDrawer.PROP_TIPS_DIFFERENTIAL, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.28"), CashDrawer.PROP_PAY_OUT_COUNT);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.29"), CashDrawer.PROP_PAY_OUT_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.30"), CashDrawer.PROP_DRAWER_BLEED_COUNT);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.31"), CashDrawer.PROP_DRAWER_BLEED_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("PosMessage.156"), CashDrawer.PROP_CASH_TO_DEPOSIT, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.32"), CashDrawer.PROP_VARIANCE, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.33"), CashDrawer.PROP_TOTAL_VOID_WST, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.34"), CashDrawer.PROP_TOTAL_VOID, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.35"), CashDrawer.PROP_TOTAL_DISCOUNT_COUNT);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.36"), CashDrawer.PROP_TOTAL_DISCOUNT_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.37"), CashDrawer.PROP_TOTAL_DISCOUNT_SALES, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.38"), CashDrawer.PROP_TOTAL_DISCOUNT_GUEST);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.39"), CashDrawer.PROP_TOTAL_DISCOUNT_PARTY_SIZE);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.40"), CashDrawer.PROP_TOTAL_DISCOUNT_CHECK_SIZE);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.41"), CashDrawer.PROP_TOTAL_DISCOUNT_PERCENTAGE, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("DrawerPullReportExplorer.42"), CashDrawer.PROP_TOTAL_DISCOUNT_RATIO, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.setPageSize(50);
        this.table = new PosTable(this.tableModel);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.table.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.table.setAutoResizeMode(0);
        this.table.setColumnControlVisible(true);
        this.resizeColumnWidth((JTable)((Object)this.table));
        this.add(new JScrollPane((Component)((Object)this.table)));
        this.restoreTableColumnsVisibility();
        this.addTableColumnListener();
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        topPanel.add((Component)new JLabel(POSConstants.FROM), "grow");
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add((Component)new JLabel(POSConstants.TO), "grow,gapleft 3");
        topPanel.add((Component)this.toDatePicker);
        topPanel.add((Component)this.btnGo, "skip 1, al right");
        this.add((Component)topPanel, "North");
        this.btnBack = new JButton(Messages.getString("DrawerPullReportExplorer.85"));
        this.btnForward = new JButton(Messages.getString("DrawerPullReportExplorer.86"));
        this.lblNumberOfItem = new JLabel();
        this.btnBack.addActionListener(e -> this.showCashDrawerReport(this.tableModel.getPreviousRowIndex()));
        this.btnForward.addActionListener(e -> this.showCashDrawerReport(this.tableModel.getNextRowIndex()));
        JPanel paginationPanel = new JPanel();
        paginationPanel.add(this.lblNumberOfItem);
        paginationPanel.add(this.btnBack);
        paginationPanel.add(this.btnForward);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.btnEditActualAmount);
        buttonPanel.add(this.btnPrint);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)buttonPanel, "Center");
        bottomPanel.add((Component)paginationPanel, "East");
        this.add((Component)bottomPanel, "South");
        this.btnPrint.addActionListener(e -> this.doPrintReport());
        this.btnGo.addActionListener(e -> this.goToViewReport());
        this.btnEditActualAmount.addActionListener(e -> this.doEditActualAmount());
    }

    private void showCashDrawerReport() {
        this.showCashDrawerReport(0);
    }

    private void showCashDrawerReport(int rowIndex) {
        try {
            this.tableModel.setCurrentRowIndex(rowIndex);
            Date fromDate = this.fromDatePicker.getDate();
            Date toDate = this.toDatePicker.getDate();
            if (fromDate.after(toDate)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
                return;
            }
            fromDate = DateUtil.startOfDay(fromDate);
            toDate = DateUtil.endOfDay(toDate);
            CashDrawerDAO.getInstance().loadCashDrawerReport(this.tableModel, fromDate, toDate);
            int startNumber = this.tableModel.getCurrentRowIndex() + 1;
            int endNumber = this.tableModel.getNextRowIndex();
            int totalNumber = this.tableModel.getNumRows();
            if (endNumber > totalNumber) {
                endNumber = totalNumber;
            }
            this.lblNumberOfItem.setText(String.format(Messages.getString("DrawerPullReportExplorer.87"), startNumber, endNumber, totalNumber));
            this.btnBack.setEnabled(this.tableModel.hasPrevious());
            this.btnForward.setEnabled(this.tableModel.hasNext());
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }

    private void restoreTableColumnsVisibility() {
        String recordedSelectedColumns = TerminalConfig.getDrawerPullReportHiddenColumns();
        TableColumnModelExt columnModel = (TableColumnModelExt)this.table.getColumnModel();
        if (recordedSelectedColumns.isEmpty()) {
            return;
        }
        String[] str = recordedSelectedColumns.split("\\*");
        for (int i = 0; i < str.length; ++i) {
            Integer columnIndex = Integer.parseInt(str[i]);
            columnModel.getColumnExt(columnIndex - i).setVisible(false);
        }
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            int columnWidthByHeader;
            int columnWidthByComponent = this.getColumnWidthByComponentLenght(table, column);
            if (columnWidthByComponent > (columnWidthByHeader = this.getColumnWidthByHeaderLenght(table, column))) {
                columnModel.getColumn(column).setPreferredWidth(columnWidthByComponent);
                continue;
            }
            columnModel.getColumn(column).setPreferredWidth(columnWidthByHeader);
        }
    }

    private int getColumnWidthByHeaderLenght(JTable table, int column) {
        int width = 50;
        TableColumn tcolumn = table.getColumnModel().getColumn(column);
        TableCellRenderer headerRenderer = tcolumn.getHeaderRenderer();
        if (headerRenderer == null) {
            headerRenderer = table.getTableHeader().getDefaultRenderer();
        }
        Object headerValue = tcolumn.getHeaderValue();
        Component headerComp = headerRenderer.getTableCellRendererComponent(table, headerValue, false, false, 0, column);
        width = Math.max(width, headerComp.getPreferredSize().width);
        return width + 20;
    }

    private int getColumnWidthByComponentLenght(JTable table, int column) {
        int width = 50;
        for (int row = 0; row < table.getRowCount(); ++row) {
            TableCellRenderer renderer = table.getCellRenderer(row, column);
            Component comp = table.prepareRenderer(renderer, row, column);
            width = Math.max(comp.getPreferredSize().width + 1, width);
        }
        return width + 20;
    }

    private void saveHiddenColumns() {
        List columns = this.columnModel.getColumns(true);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (TableColumn tableColumn : columns) {
            TableColumnExt c = (TableColumnExt)tableColumn;
            if (c.isVisible()) continue;
            indices.add(c.getModelIndex());
        }
        this.saveTableColumnsVisibility(indices);
    }

    private void saveTableColumnsVisibility(List indices) {
        String selectedColumns = "";
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            String newSelectedColumn = String.valueOf(iterator.next());
            selectedColumns = selectedColumns + newSelectedColumn;
            if (!iterator.hasNext()) continue;
            selectedColumns = selectedColumns + "*";
        }
        TerminalConfig.setDrawerPullReportHiddenColumns(selectedColumns);
    }

    private void addTableColumnListener() {
        this.columnModel = (TableColumnModelExt)this.table.getColumnModel();
        this.columnModel.addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                DrawerPullReportExplorer.this.saveHiddenColumns();
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                DrawerPullReportExplorer.this.saveHiddenColumns();
            }
        });
    }

    private void doEditActualAmount() {
        try {
            int selectedRow = this.table.getSelectedRow();
            if (selectedRow < 0) {
                POSMessageDialog.showError(this, POSConstants.SELECT_DRAWER_PULL_TO_EDIT);
                return;
            }
            String amountString = JOptionPane.showInputDialog(this, (Object)(POSConstants.ENTER_ACTUAL_AMOUNT + ":"));
            if (amountString == null) {
                return;
            }
            double amount = POSUtil.parseDouble(amountString, Messages.getString("DrawerPullReportExplorer.0"), true);
            CashDrawerDAO cashDrawerDAO = CashDrawerDAO.getInstance();
            try (Session session = cashDrawerDAO.createNewSession();){
                DrawerPullExplorerTableModel model = (DrawerPullExplorerTableModel)this.table.getModel();
                CashDrawer cashDrawer = model.getRowData(selectedRow);
                cashDrawer = cashDrawerDAO.get(cashDrawer.getId());
                cashDrawer.setCashToDeposit(amount);
                cashDrawerDAO.saveOrUpdate(cashDrawer, session);
                model.setRow(selectedRow, cashDrawer);
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
        catch (Exception e1) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e1);
        }
    }

    private void goToViewReport() {
        try {
            this.showCashDrawerReport();
            this.resizeColumnWidth((JTable)((Object)this.table));
        }
        catch (Exception e1) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e1);
        }
    }

    private void doPrintReport() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow < 0) {
            POSMessageDialog.showError(this, Messages.getString("DrawerPullReportExplorer.1"));
            return;
        }
        DrawerPullExplorerTableModel model = (DrawerPullExplorerTableModel)this.table.getModel();
        CashDrawer report = model.getRowData(selectedRow);
        try {
            PosPrintService.printDrawerPullReport(report);
        }
        catch (PosException e1) {
            POSMessageDialog.showError(this, e1.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    class DrawerPullExplorerTableModel
    extends BeanTableModel<CashDrawer> {
        public DrawerPullExplorerTableModel() {
            super(CashDrawer.class);
        }

        public CashDrawer getRowData(int selectedRow) {
            return (CashDrawer)super.getRow(selectedRow);
        }
    }
}

