/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class InventoryUnitGroupExplorer
extends TransparentPanel {
    private static final long serialVersionUID = 1L;
    private JXTable table;
    private BeanTableModel<InventoryUnitGroup> tableModel = new BeanTableModel(InventoryUnitGroup.class);
    private JTextField tfName;
    private JComboBox cbLocation;

    public InventoryUnitGroupExplorer() {
        this.tableModel.addColumn(Messages.getString("InventoryUnitGroupExplorer.0"), "id");
        this.tableModel.addColumn(Messages.getString("InventoryUnitGroupExplorer.8"), "name");
        this.tableModel.addRows(InventoryUnitGroupDAO.getInstance().findAll());
        this.table = new JXTable(this.tableModel);
        this.table.setSortOrder(0, SortOrder.ASCENDING);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    InventoryUnitGroupExplorer.this.editSelectedRow();
                }
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
        this.add((Component)this.createButtonPanel(), "South");
        this.add((Component)this.buildSearchForm(), "North");
    }

    private TransparentPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton editButton = explorerButton.getEditButton();
        JButton addButton = explorerButton.getAddButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String groupName = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), (Object)Messages.getString("InventoryUnitGroupExplorer.2"));
                    if (groupName == null) {
                        BOMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("InventoryUnitGroupExplorer.3"));
                        return;
                    }
                    if (groupName.length() > 30) {
                        BOMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("InventoryUnitGroupExplorer.4"));
                        return;
                    }
                    InventoryUnitGroup inventoryUnitGroup = new InventoryUnitGroup();
                    inventoryUnitGroup.setName(groupName);
                    InventoryUnitGroupDAO inventoryUnitGroupDAO = new InventoryUnitGroupDAO();
                    inventoryUnitGroupDAO.saveOrUpdate(inventoryUnitGroup);
                    InventoryUnitGroupExplorer.this.tableModel.addRow(inventoryUnitGroup);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryUnitGroupExplorer.this.editSelectedRow();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = InventoryUnitGroupExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        return;
                    }
                    index = InventoryUnitGroupExplorer.this.table.convertRowIndexToModel(index);
                    if (POSMessageDialog.showYesNoQuestionDialog(InventoryUnitGroupExplorer.this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    InventoryUnitGroup inventoryUnitGroup = (InventoryUnitGroup)InventoryUnitGroupExplorer.this.tableModel.getRow(index);
                    InventoryUnitGroupDAO inventoryUnitGroupDAO = new InventoryUnitGroupDAO();
                    inventoryUnitGroupDAO.delete(inventoryUnitGroup);
                    InventoryUnitGroupExplorer.this.tableModel.removeRow(index);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(addButton);
        panel.add(editButton);
        panel.add(deleteButton);
        return panel;
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        return panel;
    }

    private void searchItem() {
        String txName = this.tfName.getText();
        Object selectedGroup = this.cbLocation.getSelectedItem();
        Object similarItem = null;
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            InventoryUnitGroup inventoryUnitGroup = this.tableModel.getRow(index);
            this.tableModel.setRow(index, inventoryUnitGroup);
            String groupName = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), Messages.getString("InventoryUnitGroupExplorer.5"), inventoryUnitGroup.getName());
            if (groupName == null) {
                BOMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("InventoryUnitGroupExplorer.6"));
                return;
            }
            if (groupName.length() > 30) {
                BOMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("InventoryUnitGroupExplorer.7"));
                return;
            }
            InventoryUnitGroupDAO inventoryUnitGroupDAO = new InventoryUnitGroupDAO();
            inventoryUnitGroupDAO.saveOrUpdate(inventoryUnitGroup);
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }
}

