/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.inv.InventoryStockInForm;
import com.floreantpos.ui.inv.InventoryTransactionEntryForm;
import com.floreantpos.ui.model.MenuItemForm;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.hibernate.exception.ConstraintViolationException;
import org.jdesktop.swingx.JXTable;

public class MenuItemExplorer
extends TransparentPanel
implements ExplorerView {
    private MenuItemExplorerTable menuItemExplorerTable;
    private BeanTableModel<MenuItem> tableModel;
    private JComboBox cbCategory;
    private JTextField tfName;
    private JCheckBox cbItem;
    private JButton btnFirst;
    private JButton btnLast;
    private JButton btnBack;
    private JButton btnForward;
    private JLabel lblNumberOfItem;
    private JComboBox cbGroup;
    private JComboBox cbStatus;
    private boolean variant;
    private JPanel buttonPanel;
    private JPanel buildSearchForm;
    protected JButton btnAdd;
    protected JButton btnDelete;
    protected JButton btnDuplicate;
    private JButton btnInTransaction;
    private JButton btnOutTransaction;
    private JButton btnTransferTransaction;

    public MenuItemExplorer() {
        this(false);
    }

    public MenuItemExplorer(boolean variant) {
        this.variant = variant;
        this.init();
    }

    private void init() {
        this.tableModel = new BeanTableModel(MenuItem.class, 20);
        this.tableModel.addColumn(POSConstants.NAME, "name");
        this.tableModel.addColumn(POSConstants.TRANSLATED_NAME, "translatedName");
        this.tableModel.addColumn(Messages.getString("MenuItemExplorer.12"), "barcode");
        this.tableModel.addColumn(Messages.getString("MenuItemExplorer.27"), MenuItem.PROP_HAS_MODIFIERS);
        this.tableModel.addColumn(POSConstants.PRICE + " (" + CurrencyUtil.getCurrencySymbol() + ")", "price", 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(POSConstants.TYPE, "cmsTypeName");
        this.tableModel.addColumn(POSConstants.COURSE, "course");
        this.tableModel.addColumn(POSConstants.ACTIVE, "visible");
        this.tableModel.addColumn(POSConstants.UNIT, "unit");
        this.tableModel.addColumn(Messages.getString("MenuItemExplorer.21"), "sortOrder", BeanTableModel.EditMode.EDITABLE, 11, BeanTableModel.DataType.NUMBER);
        this.tableModel.addColumn(Messages.getString("MenuItemExplorer.23"), "buttonColor");
        this.tableModel.addColumn(Messages.getString("MenuItemExplorer.25"), "textColor");
        this.tableModel.addColumn(Messages.getString("MenuItemExplorer.31"), "shouldPrintToKitchen");
        this.tableModel.addColumn(Messages.getString("MenuItemExplorer.37"), "printerGroup");
        int iconSize = PosUIManager.getSize(16);
        this.btnFirst = new JButton();
        this.btnFirst.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.SKIP_PREVIOUS, (float)iconSize));
        this.btnBack = new JButton();
        this.btnBack.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_BEFORE, (float)iconSize));
        this.btnForward = new JButton();
        this.btnForward.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_NEXT, (float)iconSize));
        this.btnLast = new JButton();
        this.btnLast.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.SKIP_NEXT, (float)iconSize));
        this.lblNumberOfItem = new JLabel();
        this.menuItemExplorerTable = new MenuItemExplorerTable(this.tableModel);
        this.menuItemExplorerTable.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.menuItemExplorerTable.setSelectionMode(0);
        this.menuItemExplorerTable.setAutoResizeMode(0);
        this.menuItemExplorerTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                MenuItemExplorer.this.updaeButtonView();
            }
        });
        this.tableModel.initTableRenderer((JTable)((Object)this.menuItemExplorerTable));
        this.menuItemExplorerTable.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        IntegerTextField tfEditField = new IntegerTextField();
        tfEditField.setHorizontalAlignment(4);
        DefaultCellEditor editor = new DefaultCellEditor(tfEditField);
        editor.setClickCountToStart(1);
        this.menuItemExplorerTable.setDefaultEditor(this.menuItemExplorerTable.getColumnClass(8), editor);
        this.menuItemExplorerTable.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.menuItemExplorerTable.setRowHeight(PosUIManager.getSize(45));
        this.menuItemExplorerTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    MenuItemExplorer.this.editSelectedRow();
                }
            }
        });
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.showMenuItems(MenuItemExplorer.this.tableModel.getPreviousRowIndex());
            }
        });
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.showMenuItems(MenuItemExplorer.this.tableModel.getNextRowIndex());
            }
        });
        this.btnFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.showMenuItems(0);
            }
        });
        this.btnLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int totalPage = MenuItemExplorer.this.tableModel.getNumRows() / MenuItemExplorer.this.tableModel.getPageSize();
                MenuItemExplorer.this.showMenuItems(totalPage * MenuItemExplorer.this.tableModel.getPageSize());
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)((Object)this.menuItemExplorerTable)));
        this.buttonPanel = this.createButtonPanel();
        this.add((Component)this.buttonPanel, "South");
        this.buildSearchForm = this.buildSearchForm();
        this.add((Component)this.buildSearchForm, "North");
        this.resizeColumnWidth((JTable)((Object)this.menuItemExplorerTable));
    }

    protected void updaeButtonView() {
        int index = this.menuItemExplorerTable.getSelectedRow();
        if (index < 0) {
            return;
        }
        MenuItem menuItem = this.tableModel.getRow(index = this.menuItemExplorerTable.convertRowIndexToModel(index));
        this.btnInTransaction.setEnabled(menuItem.isHasVariant() == false);
        this.btnOutTransaction.setEnabled(menuItem.isHasVariant() == false);
        this.btnTransferTransaction.setEnabled(menuItem.isHasVariant() == false);
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        try {
            panel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][]15[]", "[]5[]"));
            JLabel lblCategory = new JLabel(Messages.getString("MenuItemExplorer.4"));
            this.cbCategory = new OverflowCombobox();
            this.cbCategory.addItem(Messages.getString("MenuItemExplorer.5"));
            List<MenuCategory> categories = MenuCategoryDAO.getInstance().findAll();
            for (MenuCategory category : categories) {
                this.cbCategory.addItem(category);
            }
            this.cbCategory.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MenuItemExplorer.this.doSelectGroup(e);
                }
            });
            JLabel lblName = new JLabel(Messages.getString("MenuItemExplorer.0"));
            JLabel lblGroup = new JLabel(Messages.getString("MenuItemExplorer.1"));
            this.cbGroup = new OverflowCombobox();
            this.cbGroup.addItem(Messages.getString("MenuItemExplorer.5"));
            String[] status = new String[]{Messages.getString("MenuItemExplorer.32"), Messages.getString("ACTIVE"), Messages.getString("MenuItemExplorer.34")};
            JLabel lblStatus = new JLabel(Messages.getString("MenuItemExplorer.35"));
            this.cbStatus = new JComboBox<String>(status);
            this.tfName = new JTextField(15);
            this.cbItem = new JCheckBox(Messages.getString("MenuItemExplorer.13"));
            JButton btnSearch = new JButton(Messages.getString("Search"));
            panel.add((Component)lblName, "align label");
            panel.add(this.tfName);
            panel.add(lblCategory);
            panel.add((Component)this.cbCategory, "width 120!");
            panel.add(lblGroup);
            panel.add((Component)this.cbGroup, "width 200!");
            panel.add((Component)lblStatus, "split 2");
            panel.add(this.cbStatus);
            panel.add(this.cbItem);
            panel.add(btnSearch);
            Border loweredetched = BorderFactory.createEtchedBorder(1);
            TitledBorder title = BorderFactory.createTitledBorder(loweredetched, Messages.getString("Search"));
            title.setTitleJustification(1);
            panel.setBorder(title);
            btnSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MenuItemExplorer.this.showMenuItems();
                }
            });
            KeyListener keyListener = new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (MenuItemExplorer.this.tfName.getText().length() > 2) {
                        MenuItemExplorer.this.showMenuItems();
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    int key = e.getKeyCode();
                    if (key == 10) {
                        MenuItemExplorer.this.showMenuItems();
                    }
                }
            };
            this.tfName.addKeyListener(keyListener);
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
        return panel;
    }

    public void setMenuItems(List<MenuItem> items) {
        this.tableModel.removeAll();
        this.buttonPanel.setVisible(false);
        this.buildSearchForm.setVisible(false);
        this.tableModel.addRows(items);
    }

    private void showMenuItems() {
        this.showMenuItems(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMenuItems(Integer rowIndex) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Object selectedCategory = this.cbCategory.getSelectedItem();
            Object selectedGroup = this.cbGroup.getSelectedItem();
            Object selectedStatus = this.cbStatus.getSelectedItem();
            String txName = this.tfName.getText();
            Boolean showAll = !this.cbItem.isSelected();
            MenuGroup group = null;
            MenuCategory category = null;
            Boolean status = null;
            if (selectedGroup instanceof MenuGroup) {
                group = (MenuGroup)selectedGroup;
            }
            if (selectedCategory instanceof MenuCategory) {
                category = (MenuCategory)selectedCategory;
            }
            if (selectedStatus.equals("Active")) {
                status = true;
            }
            if (selectedStatus.equals("Inactive")) {
                status = false;
            }
            if (rowIndex != null) {
                this.tableModel.setCurrentRowIndex(rowIndex);
            }
            MenuItemDAO.getInstance().loadMenuItems(this.tableModel, showAll, group, txName, category, this.variant, false, status);
            int startNumber = this.tableModel.getCurrentRowIndex() + 1;
            int endNumber = this.tableModel.getNextRowIndex();
            int totalNumber = this.tableModel.getNumRows();
            if (endNumber > totalNumber) {
                endNumber = totalNumber;
            }
            this.lblNumberOfItem.setText(String.format(Messages.getString("MenuItemExplorer.40"), startNumber, endNumber, totalNumber));
            this.btnFirst.setEnabled(this.tableModel.hasPrevious());
            this.btnBack.setEnabled(this.tableModel.hasPrevious());
            this.btnForward.setEnabled(this.tableModel.hasNext());
            this.btnLast.setEnabled(this.tableModel.hasNext());
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private JPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton btnEdit = explorerButton.getEditButton();
        this.btnAdd = explorerButton.getAddButton();
        this.btnDelete = explorerButton.getDeleteButton();
        this.btnAdd.setText(Messages.getString("MenuItemExplorer.17"));
        btnEdit.setText(Messages.getString("MenuItemExplorer.18"));
        this.btnDelete.setText(Messages.getString("MenuItemExplorer.19"));
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.editSelectedRow();
            }
        });
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.doCreateNewMenuItem();
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.doDeleteMenuItem();
            }
        });
        this.btnDuplicate = new JButton(Messages.getString("MenuItemExplorer.41"));
        this.btnDuplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuItemExplorer.this.doDuplicateMenuItem();
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][fill]"));
        TransparentPanel actionButtonPanel = new TransparentPanel();
        if (!this.variant) {
            actionButtonPanel.add(this.btnAdd);
        }
        actionButtonPanel.add(btnEdit);
        if (!this.variant) {
            actionButtonPanel.add(this.btnDelete);
            actionButtonPanel.add(this.btnDuplicate);
        }
        this.addInventoryButtonActions(actionButtonPanel);
        bottomPanel.add((Component)actionButtonPanel, "");
        JPanel navigationPanel = new JPanel(new FlowLayout(4));
        navigationPanel.add(this.lblNumberOfItem);
        navigationPanel.add(this.btnFirst);
        navigationPanel.add(this.btnBack);
        navigationPanel.add(this.btnForward);
        navigationPanel.add(this.btnLast);
        bottomPanel.add((Component)navigationPanel, "grow");
        return bottomPanel;
    }

    private void addInventoryButtonActions(JPanel panel) {
        this.btnInTransaction = new JButton(Messages.getString("MenuItemExplorer.46"));
        this.btnOutTransaction = new JButton(Messages.getString("MenuItemExplorer.47"));
        this.btnTransferTransaction = new JButton(Messages.getString("MenuItemExplorer.48"));
        this.btnInTransaction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.doShowStockInDialog(InventoryTransactionType.IN);
            }
        });
        this.btnOutTransaction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.doAdjustStock(InventoryTransactionType.OUT, false);
            }
        });
        this.btnTransferTransaction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.doAdjustStock(InventoryTransactionType.UNCHANGED, true);
            }
        });
        panel.add(this.btnInTransaction);
        panel.add(this.btnOutTransaction);
        panel.add(this.btnTransferTransaction);
    }

    private boolean doAdjustStock(InventoryTransactionType type, boolean transfer) {
        MenuItem menuItem = this.getSelectedItem();
        if (menuItem == null) {
            POSMessageDialog.showError(this, Messages.getString("MenuItemExplorer.49"));
            return false;
        }
        InventoryUnit unit = menuItem.getUnit();
        if (unit == null) {
            POSMessageDialog.showError(this, Messages.getString("MenuItemExplorer.50"));
            return false;
        }
        InventoryTransaction inventoryTransaction = new InventoryTransaction();
        inventoryTransaction.setTransactionType(type);
        if (transfer) {
            inventoryTransaction.setReason("TRANSFER");
        }
        inventoryTransaction.setMenuItem(menuItem);
        InventoryTransactionEntryForm inventoryTransactionEntryForm = new InventoryTransactionEntryForm(inventoryTransaction);
        BeanEditorDialog dialog = new BeanEditorDialog(inventoryTransactionEntryForm);
        dialog.setPreferredSize(PosUIManager.getSize(500, 500));
        dialog.open();
        if (dialog.isCanceled()) {
            return false;
        }
        this.refreshMenuItem(menuItem);
        return true;
    }

    private boolean doShowStockInDialog(InventoryTransactionType type) {
        MenuItem menuItem = this.getSelectedItem();
        InventoryTransaction inventoryTransaction = new InventoryTransaction();
        inventoryTransaction.setTransactionType(type);
        InventoryStockInForm editor = null;
        if (menuItem == null) {
            editor = new InventoryStockInForm(inventoryTransaction);
        } else {
            inventoryTransaction.setMenuItem(menuItem);
            InventoryUnit unit = menuItem.getUnit();
            if (unit == null) {
                POSMessageDialog.showError(this, Messages.getString("MenuItemExplorer.50"));
                return false;
            }
            Double replenishLevel = menuItem.getReplenishLevel();
            inventoryTransaction.setQuantity(replenishLevel);
            Double cost = menuItem.getCost();
            inventoryTransaction.setUnitCost(cost);
            inventoryTransaction.setTotal(replenishLevel * cost);
            inventoryTransaction.setUnit(menuItem.getUnit().getCode());
            editor = new InventoryStockInForm(inventoryTransaction);
        }
        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
        dialog.openWithScale(830, 630);
        if (dialog.isCanceled()) {
            return false;
        }
        this.refreshMenuItem(menuItem);
        return true;
    }

    private void refreshMenuItem(MenuItem menuItem) {
        MenuItem mItem = MenuItemDAO.getInstance().get(menuItem.getId());
        int index = this.menuItemExplorerTable.getSelectedRow();
        if (index < 0) {
            return;
        }
        index = this.menuItemExplorerTable.convertRowIndexToModel(index);
        this.tableModel.setRow(index, mItem);
        this.tableModel.fireTableRowsUpdated(index, index);
    }

    private MenuItem getSelectedItem() {
        int index = this.menuItemExplorerTable.getSelectedRow();
        MenuItem menuItem = null;
        if (index >= 0) {
            index = this.menuItemExplorerTable.convertRowIndexToModel(index);
            menuItem = this.tableModel.getRow(index);
            MenuItemDAO.getInstance().initialize(menuItem);
        }
        return menuItem;
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(200);
        columnModel.getColumn(1).setPreferredWidth(200);
        columnModel.getColumn(2).setPreferredWidth(100);
        columnModel.getColumn(4).setPreferredWidth(80);
    }

    private void editSelectedRow() {
        try {
            int index = this.menuItemExplorerTable.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToEdit"));
                return;
            }
            index = this.menuItemExplorerTable.convertRowIndexToModel(index);
            MenuItem menuItem = this.tableModel.getRow(index);
            menuItem = MenuItemDAO.getInstance().getInitialized(menuItem.getId());
            if (menuItem == null) {
                throw new PosException(Messages.getString("MenuItemExplorer.52"));
            }
            MenuItemForm editor = new MenuItemForm(menuItem);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor, true);
            dialog.openWithScale(1000, 700);
            if (!dialog.isCanceled()) {
                this.tableModel.setRow(index, menuItem);
                this.tableModel.fireTableRowsUpdated(index, index);
            }
        }
        catch (PosException e) {
            BOMessageDialog.showError(this, e.getMessage());
        }
        catch (Throwable x) {
            BOMessageDialog.showError(this, x.getMessage(), x);
        }
    }

    private void doCreateNewMenuItem() {
        try {
            MenuItem menuItem = new MenuItem();
            Object selectedType = this.cbCategory.getSelectedItem();
            if (selectedType instanceof OrderType) {
                ArrayList<OrderType> types = new ArrayList<OrderType>();
                types.add((OrderType)selectedType);
                menuItem.setOrderTypeList(types);
            }
            MenuItemForm editor = new MenuItemForm(menuItem);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor, true);
            dialog.openWithScale(1000, 700);
            if (dialog.isCanceled()) {
                return;
            }
            MenuItem foodItem = (MenuItem)editor.getBean();
            this.tableModel.addRow(foodItem);
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doDeleteMenuItem() {
        try {
            int index = this.menuItemExplorerTable.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToDelete"));
                return;
            }
            index = this.menuItemExplorerTable.convertRowIndexToModel(index);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            MenuItem item = this.tableModel.getRow(index);
            MenuItemDAO dao = MenuItemDAO.getInstance();
            dao.delete(item);
            this.tableModel.removeRow(index);
        }
        catch (ConstraintViolationException ex) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemExplorer.57"));
        }
        catch (PosException x) {
            DetailsInfoDialog dialog = new DetailsInfoDialog(x.getMessage(), x.getDetails());
            dialog.open();
        }
        catch (Exception x) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), x.getMessage(), x);
        }
    }

    @Override
    public void initData() {
        this.showMenuItems();
        List<MenuGroup> groups = MenuGroupDAO.getInstance().findAll();
        for (MenuGroup group : groups) {
            this.cbGroup.addItem(group);
        }
    }

    private void doSelectGroup(ItemEvent e) {
        try {
            Object item = e.getItem();
            this.cbGroup.removeAllItems();
            this.cbGroup.addItem(Messages.getString("MenuItemExplorer.5"));
            if (item instanceof MenuCategory) {
                MenuCategory category = (MenuCategory)item;
                List<MenuGroup> groups = MenuGroupDAO.getInstance().findByParent(category);
                for (MenuGroup group : groups) {
                    this.cbGroup.addItem(group);
                }
            } else {
                List<MenuGroup> groups = MenuGroupDAO.getInstance().findAll();
                for (MenuGroup group : groups) {
                    this.cbGroup.addItem(group);
                }
            }
        }
        catch (Exception ex) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage(), ex);
        }
    }

    private void doDuplicateMenuItem() throws Exception {
        int index = this.menuItemExplorerTable.getSelectedRow();
        if (index < 0) {
            POSMessageDialog.showError(this, Messages.getString("MenuItemExplorer.59"));
            return;
        }
        index = this.menuItemExplorerTable.convertRowIndexToModel(index);
        MenuItem existingMenuItem = this.tableModel.getRow(index);
        MenuItemDAO.getInstance().initialize(existingMenuItem);
        MenuItem newMenuItem = existingMenuItem.clone();
        MenuItemForm editor = new MenuItemForm(newMenuItem);
        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
        dialog.openWithScale(1000, 700);
        if (dialog.isCanceled()) {
            return;
        }
        MenuItem menuItem = (MenuItem)editor.getBean();
        this.tableModel.addRow(menuItem);
        this.menuItemExplorerTable.getSelectionModel().addSelectionInterval(this.tableModel.getRowCount() - 1, this.tableModel.getRowCount() - 1);
        this.menuItemExplorerTable.scrollRowToVisible(this.tableModel.getRowCount() - 1);
    }

    private class MenuItemExplorerTable
    extends JXTable {
        public MenuItemExplorerTable(TableModel dm) {
            super(dm);
        }

        public void changeSelection(int row, int column, boolean toggle, boolean extend) {
            super.changeSelection(row, column, toggle, extend);
            MenuItemExplorer.this.menuItemExplorerTable.editCellAt(row, column);
            DefaultCellEditor editor = (DefaultCellEditor)MenuItemExplorer.this.menuItemExplorerTable.getCellEditor(row, column);
            if (editor.getComponent() instanceof IntegerTextField) {
                IntegerTextField textField = (IntegerTextField)editor.getComponent();
                textField.requestFocus();
                textField.selectAll();
            }
        }

        public void setValueAt(Object sortOrderObj, int row, int column) {
            MenuItem menuItem = (MenuItem)MenuItemExplorer.this.tableModel.getRow(row);
            Integer sOrder = 0;
            if (sortOrderObj != null && sortOrderObj instanceof Integer) {
                sOrder = (Integer)sortOrderObj;
            }
            super.setValueAt((Object)sOrder, row, column);
            if (column == 10) {
                menuItem.setSortOrder(sOrder);
                MenuItemDAO.getInstance().saveOrUpdate(menuItem);
            }
        }
    }
}

