/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MultiplierForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import net.miginfocom.swing.MigLayout;

public class MultiplierExplorer
extends TransparentPanel {
    private List<Multiplier> multiplierList = MultiplierDAO.getInstance().findAll();
    private JTable table;
    private MultiplierExplorerTableModel tableModel = new MultiplierExplorerTableModel();
    private JButton btnEdit;
    private JButton btnDelete;

    public MultiplierExplorer() {
        this.table = new JTable(this.tableModel);
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.table.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.table.getColumnModel().getColumn(6).setCellRenderer(new PosTableRenderer());
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = MultiplierExplorer.this.table.getSelectedRow();
                if (index < 0) {
                    return;
                }
                Multiplier multiplier = (Multiplier)MultiplierExplorer.this.multiplierList.get(index);
                MultiplierExplorer.this.btnEdit.setEnabled(multiplier.isMain() == false);
                MultiplierExplorer.this.btnDelete.setEnabled(multiplier.isMain() == false);
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane(this.table));
        JButton btnAdd = new JButton(POSConstants.ADD);
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MultiplierForm editor = new MultiplierForm();
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MultiplierExplorer.this.tableModel.addMultiplier((Multiplier)editor.getBean());
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        this.btnEdit = new JButton(POSConstants.EDIT);
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = MultiplierExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                        return;
                    }
                    Multiplier multiplier = (Multiplier)MultiplierExplorer.this.multiplierList.get(index);
                    if (multiplier.isMain().booleanValue()) {
                        return;
                    }
                    MultiplierForm multiplierForm = new MultiplierForm(multiplier);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)multiplierForm);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MultiplierExplorer.this.table.repaint();
                }
                catch (Throwable x) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        this.btnDelete = new JButton(POSConstants.DELETE);
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = MultiplierExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    Multiplier multiplier = (Multiplier)MultiplierExplorer.this.multiplierList.get(index);
                    if (multiplier.isMain().booleanValue()) {
                        return;
                    }
                    if (ConfirmDeleteDialog.showMessage(MultiplierExplorer.this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                        MultiplierDAO.getInstance().delete(multiplier);
                        MultiplierExplorer.this.tableModel.deleteMultiplier(multiplier, index);
                    }
                }
                catch (Exception x) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton btnSetAsDefault = new JButton(Messages.getString("MultiplierExplorer.2"));
        btnSetAsDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = MultiplierExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MultiplierExplorer.3"));
                        return;
                    }
                    Multiplier selectedMultiplier = (Multiplier)MultiplierExplorer.this.multiplierList.get(index);
                    for (Multiplier item : MultiplierExplorer.this.multiplierList) {
                        if (selectedMultiplier.getId().equals(item.getId())) {
                            item.setDefaultMultiplier(true);
                            continue;
                        }
                        item.setDefaultMultiplier(false);
                    }
                    MultiplierDAO.getInstance().saveOrUpdateMultipliers(MultiplierExplorer.this.multiplierList);
                    MultiplierExplorer.this.tableModel.fireTableDataChanged();
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton btnConfigure = new JButton(Messages.getString("MultiplierExplorer.0"));
        btnConfigure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiplierExplorer.this.openMultiplierExplorerConfigurationDialog();
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(btnAdd);
        panel.add(this.btnEdit);
        panel.add(this.btnDelete);
        panel.add(btnSetAsDefault);
        panel.add(btnConfigure);
        this.add((Component)panel, "South");
    }

    private void openMultiplierExplorerConfigurationDialog() {
        MultiplierExplorerConfigurationDialog dialog = new MultiplierExplorerConfigurationDialog(Messages.getString("MultiplierExplorer.1"));
        dialog.pack();
        dialog.open();
    }

    class MultiplierExplorerTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{POSConstants.NAME, Messages.getString("MultiplierExplorer.4"), POSConstants.RATE, POSConstants.SORT_ORDER, POSConstants.BUTTON_COLOR, POSConstants.TEXT_COLOR, Messages.getString("MultiplierExplorer.5")};

        MultiplierExplorerTableModel() {
        }

        @Override
        public int getRowCount() {
            if (MultiplierExplorer.this.multiplierList == null) {
                return 0;
            }
            return MultiplierExplorer.this.multiplierList.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (MultiplierExplorer.this.multiplierList == null) {
                return "";
            }
            Multiplier multiplier = (Multiplier)MultiplierExplorer.this.multiplierList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return multiplier.getId();
                }
                case 1: {
                    return multiplier.getTicketPrefix();
                }
                case 2: {
                    return multiplier.getRate();
                }
                case 3: {
                    return multiplier.getSortOrder();
                }
                case 4: {
                    if (multiplier.getButtonColor() != null) {
                        return new Color(multiplier.getButtonColor());
                    }
                    return null;
                }
                case 5: {
                    if (multiplier.getTextColor() != null) {
                        return new Color(multiplier.getTextColor());
                    }
                    return null;
                }
                case 6: {
                    return multiplier.isDefaultMultiplier();
                }
            }
            return null;
        }

        public void addMultiplier(Multiplier multiplier) {
            int size = MultiplierExplorer.this.multiplierList.size();
            MultiplierExplorer.this.multiplierList.add(multiplier);
            this.fireTableRowsInserted(size, size);
        }

        public void deleteMultiplier(Multiplier multiplier, int index) {
            MultiplierExplorer.this.multiplierList.remove(multiplier);
            this.fireTableRowsDeleted(index, index);
        }
    }

    private class MultiplierExplorerConfigurationDialog
    extends OkCancelOptionDialog {
        private static final String EMPTY_SPACE_STRING = " ";
        private JComboBox<Multiplier> cbExtraMultiplier;
        private JComboBox<Multiplier> cbHalfMultiplier;
        private JComboBox<Multiplier> cbQuarterMultiplier;
        private Store store;
        private Multiplier extraMultiplier;
        private Multiplier halfMultiplier;
        private Multiplier quarterMultiplier;

        public MultiplierExplorerConfigurationDialog(String dialogTitle) {
            super(POSUtil.getFocusedWindow(), dialogTitle);
            this.store = DataProvider.get().getStore();
            this.init();
        }

        private void init() {
            this.setDefaultCloseOperation(2);
            this.setResizable(Boolean.FALSE);
            JPanel contentPanel = new JPanel();
            MigLayout layout = new MigLayout("fill,inset 0", "sg, fill", "");
            contentPanel.setLayout((LayoutManager)layout);
            JLabel lblExtraMultiplier = new JLabel(Messages.getString("MultiplierExplorer.8"));
            JLabel lblHalfMultiplier = new JLabel(Messages.getString("MultiplierExplorer.9"));
            JLabel lblQuarterMultiplier = new JLabel(Messages.getString("MultiplierExplorer.10"));
            this.extraMultiplier = this.store.getExtraMultiplier();
            this.halfMultiplier = this.store.getHalfMultiplier();
            this.quarterMultiplier = this.store.getQuarterMultiplier();
            ComboBoxModel multiplierModel = new ComboBoxModel();
            multiplierModel.getDataList().add(null);
            for (Multiplier multiplier : MultiplierExplorer.this.multiplierList) {
                multiplierModel.getDataList().add(multiplier);
            }
            this.cbExtraMultiplier = new JComboBox(multiplierModel);
            this.cbExtraMultiplier.setSelectedItem(this.extraMultiplier);
            multiplierModel = new ComboBoxModel();
            multiplierModel.getDataList().add(null);
            for (Multiplier multiplier : MultiplierExplorer.this.multiplierList) {
                multiplierModel.getDataList().add(multiplier);
            }
            this.cbHalfMultiplier = new JComboBox(multiplierModel);
            this.cbHalfMultiplier.setSelectedItem(this.halfMultiplier);
            multiplierModel = new ComboBoxModel();
            multiplierModel.getDataList().add(null);
            for (Multiplier multiplier : MultiplierExplorer.this.multiplierList) {
                multiplierModel.getDataList().add(multiplier);
            }
            this.cbQuarterMultiplier = new JComboBox(multiplierModel);
            this.cbQuarterMultiplier.setSelectedItem(this.quarterMultiplier);
            contentPanel.add((Component)lblExtraMultiplier, "grow");
            contentPanel.add(this.cbExtraMultiplier, "grow, wrap");
            contentPanel.add((Component)lblHalfMultiplier, "grow");
            contentPanel.add(this.cbHalfMultiplier, "grow, wrap");
            contentPanel.add((Component)lblQuarterMultiplier, "grow");
            contentPanel.add(this.cbQuarterMultiplier, "grow, wrap");
            this.cbExtraMultiplier.addItemListener(e -> this.selectExtraMultiplierAction());
            this.cbHalfMultiplier.addItemListener(e -> this.selectHalfMultiplierAction());
            this.cbQuarterMultiplier.addItemListener(e -> this.selectQuarterMultiplierAction());
            this.getContentPanel().add((Component)contentPanel, "Center");
        }

        private void selectExtraMultiplierAction() {
            try {
                Multiplier selectedMultiplier;
                this.extraMultiplier = selectedMultiplier = (Multiplier)this.cbExtraMultiplier.getSelectedItem();
            }
            catch (Exception e0) {
                PosLog.error(this.getClass(), e0);
            }
        }

        private void selectHalfMultiplierAction() {
            try {
                Multiplier selectedMultiplier;
                this.halfMultiplier = selectedMultiplier = (Multiplier)this.cbHalfMultiplier.getSelectedItem();
            }
            catch (Exception e0) {
                PosLog.error(this.getClass(), e0);
            }
        }

        private void selectQuarterMultiplierAction() {
            try {
                Multiplier selectedMultiplier;
                this.quarterMultiplier = selectedMultiplier = (Multiplier)this.cbQuarterMultiplier.getSelectedItem();
            }
            catch (Exception e0) {
                PosLog.error(this.getClass(), e0);
            }
        }

        @Override
        public void doOk() {
            try {
                if (this.extraMultiplier != null && this.extraMultiplier.equals(this.halfMultiplier)) {
                    String message = Messages.getString("MultiplierExplorer.11") + EMPTY_SPACE_STRING + Messages.getString("MultiplierExplorer.12");
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
                    return;
                }
                if (this.extraMultiplier != null && this.extraMultiplier.equals(this.quarterMultiplier)) {
                    String message = Messages.getString("MultiplierExplorer.13") + EMPTY_SPACE_STRING + Messages.getString("MultiplierExplorer.12");
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
                    return;
                }
                if (this.halfMultiplier != null && this.halfMultiplier.equals(this.quarterMultiplier)) {
                    String message = Messages.getString("MultiplierExplorer.15") + EMPTY_SPACE_STRING + Messages.getString("MultiplierExplorer.12");
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
                    return;
                }
                StoreDAO.getInstance().saveOrUpdate(this.store.setExtraMultiplier(this.extraMultiplier).setHalfMultiplier(this.halfMultiplier).setQuarterMultiplier(this.quarterMultiplier));
                this.setCanceled(false);
                this.dispose();
            }
            catch (Exception e0) {
                PosLog.error(this.getClass(), e0);
            }
        }
    }
}

