/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.bo.ui.explorer.OutletEntryForm;
import com.floreantpos.config.AppProperties;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class OutletExplorer
extends TransparentPanel {
    private static final long serialVersionUID = 1L;
    private JXTable table;
    private BeanTableModel<Outlet> tableModel = new BeanTableModel(Outlet.class);
    private JTextField tfName;
    private JComboBox cbLocation;

    public OutletExplorer() {
        this.tableModel.addColumn(Messages.getString("OutletExplorer.0"), "id");
        this.tableModel.addColumn(Messages.getString("OutletExplorer.2"), "name");
        this.tableModel.addColumn(Messages.getString("OutletExplorer.4"), "description");
        this.tableModel.addColumn(Messages.getString("OutletExplorer.1"), "address");
        this.tableModel.addRows(OutletDAO.getInstance().findAll());
        this.table = new JXTable(this.tableModel);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    OutletExplorer.this.editSelectedRow();
                }
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
        this.add((Component)this.createButtonPanel(), "South");
        this.add((Component)this.buildSearchForm(), "North");
    }

    private TransparentPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton editButton = explorerButton.getEditButton();
        JButton addButton = explorerButton.getAddButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    OutletEntryForm editor = new OutletEntryForm(new Outlet());
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.setSize(PosUIManager.getSize(500, 600));
                    dialog.setTitle(AppProperties.getAppName());
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    Outlet outlet = (Outlet)editor.getBean();
                    OutletExplorer.this.tableModel.addRow(outlet);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutletExplorer.this.editSelectedRow();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = OutletExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        return;
                    }
                    index = OutletExplorer.this.table.convertRowIndexToModel(index);
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    Outlet itemOutlet = (Outlet)OutletExplorer.this.tableModel.getRow(index);
                    OutletDAO outletDAO = new OutletDAO();
                    outletDAO.delete(itemOutlet);
                    OutletExplorer.this.tableModel.removeRow(index);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(addButton);
        panel.add(editButton);
        panel.add(deleteButton);
        return panel;
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        return panel;
    }

    private void searchItem() {
        String txName = this.tfName.getText();
        Object selectedGroup = this.cbLocation.getSelectedItem();
        Object similarItem = null;
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            Outlet outlet = this.tableModel.getRow(index);
            outlet = OutletDAO.getInstance().initialize(outlet);
            this.tableModel.setRow(index, outlet);
            OutletEntryForm editor = new OutletEntryForm(outlet);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.setSize(PosUIManager.getSize(500, 600));
            dialog.setTitle(AppProperties.getAppName());
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }
}

